#!/bin/bash

# Phase 5 Session 修复验证测试

echo "========================================"
echo "Phase 5 Session 修复验证"
echo "========================================"
echo ""

# 清理测试数据
echo "清理测试数据..."
rm -rf ~/.codelin/sessions/metadata/*.json
echo ""

echo "测试 1: 启动 CLI 并检查欢迎信息"
echo "========================================"
echo -e "exit" | cjpm run --name cli 2>&1 | grep -A 10 "Quick Start" | head -15
echo ""

echo "测试 2: 检查会话指示器是否显示"
echo "========================================"
echo -e "exit" | cjpm run --name cli 2>&1 | grep -E "\[New Chat\]|" | head -5
echo ""

echo "测试 3: 测试 /sessions 命令"
echo "========================================"
echo -e "/sessions\nexit" | cjpm run --name cli 2>&1 | grep -A 10 "Your Sessions"
echo ""

echo "测试 4: 测试 /new 命令"
echo "========================================"
echo -e "/new\nexit" | cjpm run --name cli 2>&1 | grep "Started new session"
echo ""

echo "测试 5: 测试 /rename 命令"
echo "========================================"
echo -e "/rename Test Session\nexit" | cjpm run --name cli 2>&1 | grep "renamed"
echo ""

echo "测试 6: 验证元数据文件创建"
echo "========================================"
if [ -f ~/.codelin/sessions/metadata/last-conversation.json ]; then
    echo "✅ 元数据文件已创建"
    echo "内容:"
    cat ~/.codelin/sessions/metadata/last-conversation.json | head -5
else
    echo "❌ 元数据文件未创建"
fi
echo ""

echo "========================================"
echo "测试完成"
echo "========================================"

