# Cangjie TUI Framework

基于仓颉语言构建的现代化终端用户界面(TUI)框架，提供高性能、跨平台的终端应用开发能力。

## 🚀 特性

- **组件化架构** - 基于组件的可复用UI设计
- **灵活布局系统** - 支持Vertical、Horizontal、Grid、Flexbox等布局
- **事件驱动** - 完整的键盘、鼠标事件处理机制
- **主题支持** - 可定制的颜色和样式主题
- **高性能渲染** - 支持脏矩形优化和双缓冲渲染
- **跨平台兼容** - 支持各种现代终端

## 📦 项目结构

```
tui/
├── src/
│   ├── main.cj          # 程序入口
│   ├── types.cj          # 基础类型定义
│   ├── events.cj         # 事件系统
│   ├── terminal.cj       # 终端控制
│   ├── components.cj     # UI组件
│   ├── layout.cj         # 布局管理
│   ├── renderer.cj       # 渲染引擎
│   ├── application.cj    # 应用程序管理
│   └── examples.cj       # 示例应用
├── cjpm.toml            # 项目配置
└── README.md             # 项目说明
```

## 🎯 核心组件

### 基础类型
- `Point` - 二维坐标点
- `Size` - 尺寸信息
- `Rect` - 矩形区域
- `Color` - 颜色定义
- `TextStyle` - 文本样式

### UI组件
- `Component` - 组件基类接口
- `BaseComponent` - 基础组件类
- `TextComponent` - 文本显示组件
- `ButtonComponent` - 按钮组件
- `InputComponent` - 输入框组件
- `ContainerComponent` - 容器组件

### 布局管理
- `Layout` - 布局接口
- `VerticalLayout` - 垂直布局
- `HorizontalLayout` - 水平布局
- `GridLayout` - 网格布局
- `FlexLayout` - 弹性布局
- `StackLayout` - 堆叠布局

### 事件系统
- `Event` - 事件基类
- `KeyEvent` - 键盘事件
- `MouseEvent` - 鼠标事件
- `EventDispatcher` - 事件分发器
- `EventManager` - 事件管理器

### 渲染引擎
- `Renderer` - 渲染器接口
- `TerminalRenderer` - 基础终端渲染器
- `BufferedRenderer` - 缓冲渲染器
- `RenderContext` - 渲染上下文

## 🛠️ 构建和运行

```bash
# 构建项目
cjpm build

# 运行示例
cjpm run
```

## 📖 使用示例

### Hello World

```cangjie
import tui.*

main(): Int64 {
    let app = Application(title: "Hello TUI")
    let container = ContainerComponent(id: "main")
    let layout = VerticalLayout(spacing: 1, alignment: .Center)
    container.setLayout(layout: layout)
    
    let text = TextComponent(id: "text", text: "Hello, TUI World!")
    text.setSize(size: Size(width: 20, height: 1))
    
    container.addChild(child: text)
    app.setRootComponent(component: container)
    app.start()
    
    return 0
}
```

### 登录界面

```cangjie
import tui.*

func createLoginForm() -> Component {
    let container = ContainerComponent(id: "login")
    let layout = VerticalLayout(spacing: 2, alignment: .Center)
    container.setLayout(layout: layout)
    
    let title = TextComponent(id: "title", text: "Login")
    let username = InputComponent(id: "username")
    let password = InputComponent(id: "password")
    password.setPassword(password: true)
    
    let button = ButtonComponent(id: "login", text: "Login")
    button.setOnClick {
        println("Login clicked!")
    }
    
    container.addChild(child: title)
    container.addChild(child: username)
    container.addChild(child: password)
    container.addChild(child: button)
    
    return container
}
```

## 🎨 主题系统

框架支持多种预定义主题：

```cangjie
// 默认主题
let app = Application(title: "App")
app.setTheme(theme: Theme.defaultTheme())

// 暗色主题
app.setTheme(theme: Theme.darkTheme())

// 亮色主题
app.setTheme(theme: Theme.lightTheme())

// 自定义主题
let customTheme = Theme(
    primary: Color.blue(),
    background: Color.black(),
    foreground: Color.white()
)
app.setTheme(theme: customTheme)
```

## 📋 示例应用

项目包含多个示例应用，展示框架的各种功能：

1. **Hello World** - 简单的欢迎界面
2. **Login Form** - 登录表单演示
3. **File Manager** - 文件管理器界面
4. **Grid Layout** - 网格布局示例

## 🔮 开发计划

- [ ] 完善组件库（Table、Tree、Menu等）
- [ ] 添加动画支持
- [ ] 实现主题热切换
- [ ] 支持插件系统
- [ ] 性能优化和内存管理
- [ ] 添加更多示例应用
- [ ] 完善文档和API参考

## 🤝 贡献

欢迎提交Issue和Pull Request来帮助改进这个框架！

## 📄 许可证

MIT License

## 🙏 致谢

感谢仓颉语言社区和相关项目的启发。

---

**Cangjie TUI Framework** - 让终端应用开发更简单、更高效！