#!/bin/bash

# 非交互式快速验证
# 自动发送测试命令并捕获输出

echo "🧪 CodeLin v6.1 非交互式快速验证"
echo "════════════════════════════════════════════════════════════════"
echo ""

source $CANGJIE_HOME/envsetup.sh

echo "📋 测试序列:"
echo "  1. /help - 帮助命令"
echo "  2. 简单问答测试"
echo "  3. /exit - 退出"
echo ""

# 创建测试输入
cat > /tmp/codelin_test_input.txt << 'EOF'
/help
你好
/exit
EOF

echo "🚀 执行测试..."
echo ""

# 运行测试（5秒超时）
(
  cat /tmp/codelin_test_input.txt
  sleep 5
) | cjpm run --name cli 2>&1 | tee /tmp/codelin_test_output.log

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "📊 验证结果分析:"
echo ""

# 分析输出
if grep -q "Codelin Commands" /tmp/codelin_test_output.log; then
  echo "  ✅ CLI 启动成功"
else
  echo "  ❌ CLI 启动失败"
fi

if grep -q "/help" /tmp/codelin_test_output.log; then
  echo "  ✅ /help 命令响应正常"
else
  echo "  ❌ /help 命令未响应"
fi

if grep -q "Thanks for using Codelin" /tmp/codelin_test_output.log; then
  echo "  ✅ 退出流程正常"
else
  echo "  ❌ 退出异常"
fi

echo ""
echo "📁 完整日志: /tmp/codelin_test_output.log"
echo ""

# 检查新功能编译
echo "🔍 新功能编译验证:"
if [ -f "src/core/agents/subagents/execution_loop_agent.cj" ]; then
  echo "  ✅ ExecutionLoopAgent 源文件存在 ($(wc -l < src/core/agents/subagents/execution_loop_agent.cj) 行)"
else
  echo "  ❌ ExecutionLoopAgent 源文件缺失"
fi

if [ -f "src/core/tools/batch_edit_toolset.cj" ]; then
  echo "  ✅ BatchEditToolset 源文件存在 ($(wc -l < src/core/tools/batch_edit_toolset.cj) 行)"
else
  echo "  ❌ BatchEditToolset 源文件缺失"
fi

if [ -f "target/release/bin/cli" ]; then
  echo "  ✅ CLI 可执行文件存在 ($(ls -lh target/release/bin/cli | awk '{print $5}'))"
else
  echo "  ❌ CLI 可执行文件缺失"
fi

echo ""
echo "🎉 快速验证完成！"
echo ""
echo "💡 提示: 要进行完整的交互式验证，请运行:"
echo "   ./run_cli_interactive.sh"
echo ""
