package mill.scalalib

import mill.api.Discover
import mill.scalalib.HelloWorldTests.*
import mill.testkit.{TestRootModule, UnitTester}
import mill.util.TokenReaders.*
import utest.*

object ScalaFlagsTests extends TestSuite {

  object HelloWorldFlags extends TestRootModule {
    object core extends ScalaModule {
      def scalaVersion = scala212Version

      override def scalacOptions = super.scalacOptions() ++ Seq(
        "-Ypartial-unification"
      )
    }

    lazy val millDiscover = Discover[this.type]
  }

  def tests: Tests = Tests {

    test("flags") {
      // make sure flags are passed when compiling/running
      test("runMain") - UnitTester(
        HelloWorldFlags,
        sourceRoot = os.Path(sys.env("MILL_TEST_RESOURCE_DIR")) / "hello-world-flags"
      ).scoped { eval =>
        val Right(result) = eval.apply(HelloWorldFlags.core.runMain("Main")).runtimeChecked
        assert(result.evalCount > 0)
      }
      // make sure flags are passed during ScalaDoc generation
      test("docJar") - UnitTester(
        HelloWorldFlags,
        sourceRoot = os.Path(sys.env("MILL_TEST_RESOURCE_DIR")) / "hello-world-flags"
      ).scoped { eval =>
        val Right(result) = eval.apply(HelloWorldFlags.core.docJar).runtimeChecked
        assert(result.evalCount > 0)
      }
    }
  }
}
