"""remove unused tool_providers

Revision ID: 11b07f66c737
Revises: cf8f4fc45278
Create Date: 2024-12-19 17:46:25.780116

"""
from alembic import op
import models as models
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '11b07f66c737'
down_revision = 'cf8f4fc45278'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tool_providers')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    
    if _is_pg(conn):
        op.create_table('tool_providers',
        sa.Column('id', sa.UUID(), server_default=sa.text('uuid_generate_v4()'), autoincrement=False, nullable=False),
        sa.Column('tenant_id', sa.UUID(), autoincrement=False, nullable=False),
        sa.Column('tool_name', sa.VARCHAR(length=40), autoincrement=False, nullable=False),
        sa.Column('encrypted_credentials', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('is_enabled', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP(0)'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP(0)'), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('id', name='tool_provider_pkey'),
        sa.UniqueConstraint('tenant_id', 'tool_name', name='unique_tool_provider_tool_name')
        )
    else:
        op.create_table('tool_providers',
        sa.Column('id', models.types.StringUUID(), autoincrement=False, nullable=False),
        sa.Column('tenant_id', models.types.StringUUID(), autoincrement=False, nullable=False),
        sa.Column('tool_name', sa.VARCHAR(length=40), autoincrement=False, nullable=False),
        sa.Column('encrypted_credentials', models.types.LongText(), autoincrement=False, nullable=True),
        sa.Column('is_enabled', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
        sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.func.current_timestamp(), autoincrement=False, nullable=False),
        sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.func.current_timestamp(), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('id', name='tool_provider_pkey'),
        sa.UniqueConstraint('tenant_id', 'tool_name', name='unique_tool_provider_tool_name')
        )
    # ### end Alembic commands ###
