"""mysql adaptation

Revision ID: 09cfdda155d1
Revises: 669ffd70119c
Create Date: 2025-11-15 21:02:32.472885

"""
from alembic import op
import models as models
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql, mysql

def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '09cfdda155d1'
down_revision = '669ffd70119c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if _is_pg(conn):
       with op.batch_alter_table('datasource_providers', schema=None) as batch_op:
              batch_op.alter_column('provider',
                     existing_type=sa.VARCHAR(length=255),
                     type_=sa.String(length=128),
                     existing_nullable=False)

       with op.batch_alter_table('external_knowledge_bindings', schema=None) as batch_op:
              batch_op.alter_column('external_knowledge_id',
                     existing_type=sa.TEXT(),
                     type_=sa.String(length=512),
                     existing_nullable=False)

       with op.batch_alter_table('tenant_plugin_auto_upgrade_strategies', schema=None) as batch_op:
              batch_op.alter_column('exclude_plugins',
                     existing_type=postgresql.ARRAY(sa.VARCHAR(length=255)),
                     type_=sa.JSON(),
                     existing_nullable=False,
                     postgresql_using='to_jsonb(exclude_plugins)::json') 
              
              batch_op.alter_column('include_plugins',
                     existing_type=postgresql.ARRAY(sa.VARCHAR(length=255)),
                     type_=sa.JSON(),
                     existing_nullable=False,
                     postgresql_using='to_jsonb(include_plugins)::json') 

       with op.batch_alter_table('tool_oauth_tenant_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=sa.VARCHAR(length=512),
                     type_=sa.String(length=255),
                     existing_nullable=False)

       with op.batch_alter_table('trigger_oauth_system_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=sa.VARCHAR(length=512),
                     type_=sa.String(length=255),
                     existing_nullable=False)
    else:
       with op.batch_alter_table('trigger_oauth_system_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=mysql.VARCHAR(length=512),
                     type_=sa.String(length=255),
                     existing_nullable=False)

       with op.batch_alter_table('workflows', schema=None) as batch_op:
              batch_op.alter_column('updated_at',
                     existing_type=mysql.TIMESTAMP(),
                     type_=sa.DateTime(),
                     existing_nullable=False)


    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if _is_pg(conn):
       with op.batch_alter_table('trigger_oauth_system_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=sa.String(length=255),
                     type_=sa.VARCHAR(length=512),
                     existing_nullable=False)

       with op.batch_alter_table('tool_oauth_tenant_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=sa.String(length=255),
                     type_=sa.VARCHAR(length=512),
                     existing_nullable=False)

       with op.batch_alter_table('tenant_plugin_auto_upgrade_strategies', schema=None) as batch_op:
              batch_op.alter_column('include_plugins',
                     existing_type=sa.JSON(),
                     type_=postgresql.ARRAY(sa.VARCHAR(length=255)),
                     existing_nullable=False,
                     postgresql_using="""
                     COALESCE(
                         regexp_replace(
                             replace(replace(include_plugins::text, '[', '{'), ']', '}'),
                             '"',
                             '',
                             'g'
                         )::varchar(255)[],
                         ARRAY[]::varchar(255)[]
                     )""")
              batch_op.alter_column('exclude_plugins',
                     existing_type=sa.JSON(),
                     type_=postgresql.ARRAY(sa.VARCHAR(length=255)),
                     existing_nullable=False,
                     postgresql_using="""
                     COALESCE(
                         regexp_replace(
                             replace(replace(exclude_plugins::text, '[', '{'), ']', '}'),
                             '"',
                             '',
                             'g'
                         )::varchar(255)[],
                         ARRAY[]::varchar(255)[]
                     )""")

       with op.batch_alter_table('external_knowledge_bindings', schema=None) as batch_op:
              batch_op.alter_column('external_knowledge_id',
                     existing_type=sa.String(length=512),
                     type_=sa.TEXT(),
                     existing_nullable=False)

       with op.batch_alter_table('datasource_providers', schema=None) as batch_op:
              batch_op.alter_column('provider',
                     existing_type=sa.String(length=128),
                     type_=sa.VARCHAR(length=255),
                     existing_nullable=False)

    else:
       with op.batch_alter_table('workflows', schema=None) as batch_op:
              batch_op.alter_column('updated_at',
                     existing_type=sa.DateTime(),
                     type_=mysql.TIMESTAMP(),
                     existing_nullable=False)

       with op.batch_alter_table('trigger_oauth_system_clients', schema=None) as batch_op:
              batch_op.alter_column('plugin_id',
                     existing_type=sa.String(length=255),
                     type_=mysql.VARCHAR(length=512),
                     existing_nullable=False)

    # ### end Alembic commands ###
