"""add credit pool

Revision ID: 7df29de0f6be
Revises: 03ea244985ce
Create Date: 2025-12-25 10:39:15.139304

"""
from alembic import op
import models as models
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '7df29de0f6be'
down_revision = '03ea244985ce'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tenant_credit_pools',
    sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
    sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
    sa.Column('pool_type', sa.String(length=40), server_default='trial', nullable=False),
    sa.Column('quota_limit', sa.BigInteger(), nullable=False),
    sa.Column('quota_used', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.PrimaryKeyConstraint('id', name='tenant_credit_pool_pkey')
    )
    with op.batch_alter_table('tenant_credit_pools', schema=None) as batch_op:
        batch_op.create_index('tenant_credit_pool_pool_type_idx', ['pool_type'], unique=False)
        batch_op.create_index('tenant_credit_pool_tenant_id_idx', ['tenant_id'], unique=False)

    # ### end Alembic commands ###


def downgrade():
   
    with op.batch_alter_table('tenant_credit_pools', schema=None) as batch_op:
        batch_op.drop_index('tenant_credit_pool_tenant_id_idx')
        batch_op.drop_index('tenant_credit_pool_pool_type_idx')

    op.drop_table('tenant_credit_pools')
    # ### end Alembic commands ###
