"""create workflow_archive_logs

Revision ID: 9d77545f524e
Revises: f9f6d18a37f9
Create Date: 2026-01-06 17:18:56.292479

"""
from alembic import op
import models as models
import sqlalchemy as sa


def _is_pg(conn):
    return conn.dialect.name == "postgresql"

# revision identifiers, used by Alembic.
revision = '9d77545f524e'
down_revision = 'f9f6d18a37f9'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    if _is_pg(conn):
        op.create_table('workflow_archive_logs',
        sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
        sa.Column('log_id', models.types.StringUUID(), nullable=True),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_run_id', models.types.StringUUID(), nullable=False),
        sa.Column('created_by_role', sa.String(length=255), nullable=False),
        sa.Column('created_by', models.types.StringUUID(), nullable=False),
        sa.Column('log_created_at', sa.DateTime(), nullable=True),
        sa.Column('log_created_from', sa.String(length=255), nullable=True),
        sa.Column('run_version', sa.String(length=255), nullable=False),
        sa.Column('run_status', sa.String(length=255), nullable=False),
        sa.Column('run_triggered_from', sa.String(length=255), nullable=False),
        sa.Column('run_error', models.types.LongText(), nullable=True),
        sa.Column('run_elapsed_time', sa.Float(), server_default=sa.text('0'), nullable=False),
        sa.Column('run_total_tokens', sa.BigInteger(), server_default=sa.text('0'), nullable=False),
        sa.Column('run_total_steps', sa.Integer(), server_default=sa.text('0'), nullable=True),
        sa.Column('run_created_at', sa.DateTime(), nullable=False),
        sa.Column('run_finished_at', sa.DateTime(), nullable=True),
        sa.Column('run_exceptions_count', sa.Integer(), server_default=sa.text('0'), nullable=True),
        sa.Column('trigger_metadata', models.types.LongText(), nullable=True),
        sa.Column('archived_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_archive_log_pkey')
        )
    else:
        op.create_table('workflow_archive_logs',
        sa.Column('id', models.types.StringUUID(), nullable=False),
        sa.Column('log_id', models.types.StringUUID(), nullable=True),
        sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
        sa.Column('app_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_id', models.types.StringUUID(), nullable=False),
        sa.Column('workflow_run_id', models.types.StringUUID(), nullable=False),
        sa.Column('created_by_role', sa.String(length=255), nullable=False),
        sa.Column('created_by', models.types.StringUUID(), nullable=False),
        sa.Column('log_created_at', sa.DateTime(), nullable=True),
        sa.Column('log_created_from', sa.String(length=255), nullable=True),
        sa.Column('run_version', sa.String(length=255), nullable=False),
        sa.Column('run_status', sa.String(length=255), nullable=False),
        sa.Column('run_triggered_from', sa.String(length=255), nullable=False),
        sa.Column('run_error', models.types.LongText(), nullable=True),
        sa.Column('run_elapsed_time', sa.Float(), server_default=sa.text('0'), nullable=False),
        sa.Column('run_total_tokens', sa.BigInteger(), server_default=sa.text('0'), nullable=False),
        sa.Column('run_total_steps', sa.Integer(), server_default=sa.text('0'), nullable=True),
        sa.Column('run_created_at', sa.DateTime(), nullable=False),
        sa.Column('run_finished_at', sa.DateTime(), nullable=True),
        sa.Column('run_exceptions_count', sa.Integer(), server_default=sa.text('0'), nullable=True),
        sa.Column('trigger_metadata', models.types.LongText(), nullable=True),
        sa.Column('archived_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
        sa.PrimaryKeyConstraint('id', name='workflow_archive_log_pkey')
        )
    with op.batch_alter_table('workflow_archive_logs', schema=None) as batch_op:
        batch_op.create_index('workflow_archive_log_app_idx', ['tenant_id', 'app_id'], unique=False)
        batch_op.create_index('workflow_archive_log_run_created_at_idx', ['run_created_at'], unique=False)
        batch_op.create_index('workflow_archive_log_workflow_run_id_idx', ['workflow_run_id'], unique=False)


    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('workflow_archive_logs', schema=None) as batch_op:
        batch_op.drop_index('workflow_archive_log_workflow_run_id_idx')
        batch_op.drop_index('workflow_archive_log_run_created_at_idx')
        batch_op.drop_index('workflow_archive_log_app_idx')

    op.drop_table('workflow_archive_logs')
    # ### end Alembic commands ###
