/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.OAuth;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftSession;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.gson.ValidationTypeAdapterFactory;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.HttpMultipartRequest;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.javafx.ObservableOptionalCache;
import org.jackhuang.hmcl.util.logging.Logger;

public class MicrosoftService {
    private static final String SCOPE = "XboxLive.signin offline_access";
    private static final ThreadPoolExecutor POOL = Lang.threadPool("MicrosoftProfileProperties", true, 2, 10L, TimeUnit.SECONDS);
    private final OAuth.Callback callback;
    private final ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> profileRepository;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), UUIDTypeAdapter.INSTANCE).registerTypeAdapterFactory(ValidationTypeAdapterFactory.INSTANCE).create();

    public MicrosoftService(OAuth.Callback callback) {
        this.callback = Objects.requireNonNull(callback);
        this.profileRepository = new ObservableOptionalCache(uuid -> {
            Logger.LOG.info("Fetching properties of " + String.valueOf(uuid));
            return this.getCompleteGameProfile((UUID)uuid);
        }, (uuid, e) -> Logger.LOG.warning("Failed to fetch properties of " + String.valueOf(uuid), (Throwable)e), POOL);
    }

    public ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> getProfileRepository() {
        return this.profileRepository;
    }

    public MicrosoftSession authenticate() throws AuthenticationException {
        try {
            OAuth.Result result = OAuth.MICROSOFT.authenticate(OAuth.GrantFlow.DEVICE, new OAuth.Options(SCOPE, this.callback));
            return this.authenticateViaLiveAccessToken(result.getAccessToken(), result.getRefreshToken());
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    public MicrosoftSession refresh(MicrosoftSession oldSession) throws AuthenticationException {
        try {
            OAuth.Result result = OAuth.MICROSOFT.refresh(oldSession.getRefreshToken(), new OAuth.Options(SCOPE, this.callback));
            return this.authenticateViaLiveAccessToken(result.getAccessToken(), result.getRefreshToken());
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    private String getUhs(XBoxLiveAuthenticationResponse response, String existingUhs) throws AuthenticationException {
        if (response.errorCode != 0L) {
            throw new XboxAuthorizationException(response.errorCode, response.redirectUrl);
        }
        if (response.displayClaims == null || response.displayClaims.xui == null || response.displayClaims.xui.size() == 0 || !response.displayClaims.xui.get(0).containsKey("uhs")) {
            Logger.LOG.warning("Unrecognized xbox authorization response " + GSON.toJson(response));
            throw new NoXuiException();
        }
        String uhs = (String)response.displayClaims.xui.get(0).get("uhs");
        if (existingUhs != null && !Objects.equals(uhs, existingUhs)) {
            throw new ServerResponseMalformedException("uhs mismatched");
        }
        return uhs;
    }

    private MicrosoftSession authenticateViaLiveAccessToken(String liveAccessToken, String liveRefreshToken) throws IOException, JsonParseException, AuthenticationException {
        XBoxLiveAuthenticationResponse minecraftXstsResponse;
        String uhs;
        try {
            XBoxLiveAuthenticationResponse xboxResponse = HttpRequest.POST("https://user.auth.xboxlive.com/user/authenticate").json(Lang.mapOf(Pair.pair("Properties", Lang.mapOf(Pair.pair("AuthMethod", "RPS"), Pair.pair("SiteName", "user.auth.xboxlive.com"), Pair.pair("RpsTicket", "d=" + liveAccessToken))), Pair.pair("RelyingParty", "http://auth.xboxlive.com"), Pair.pair("TokenType", "JWT"))).retry(5).accept("application/json").getJson(XBoxLiveAuthenticationResponse.class);
            uhs = this.getUhs(xboxResponse, null);
            minecraftXstsResponse = HttpRequest.POST("https://xsts.auth.xboxlive.com/xsts/authorize").json(Lang.mapOf(Pair.pair("Properties", Lang.mapOf(Pair.pair("SandboxId", "RETAIL"), Pair.pair("UserTokens", Collections.singletonList(xboxResponse.token)))), Pair.pair("RelyingParty", "rp://api.minecraftservices.com/"), Pair.pair("TokenType", "JWT"))).ignoreHttpErrorCode(401).retry(5).getJson(XBoxLiveAuthenticationResponse.class);
        }
        catch (ResponseCodeException e) {
            if (e.getResponseCode() == 400) {
                throw new XBox400Exception();
            }
            throw e;
        }
        this.getUhs(minecraftXstsResponse, uhs);
        MinecraftLoginWithXBoxResponse minecraftResponse = HttpRequest.POST("https://api.minecraftservices.com/authentication/login_with_xbox").json(Lang.mapOf(Pair.pair("identityToken", "XBL3.0 x=" + uhs + ";" + minecraftXstsResponse.token))).retry(5).accept("application/json").getJson(MinecraftLoginWithXBoxResponse.class);
        long notAfter = (long)minecraftResponse.expiresIn * 1000L + System.currentTimeMillis();
        HttpURLConnection request = HttpRequest.GET("https://api.minecraftservices.com/entitlements/mcstore").authorization("Bearer " + minecraftResponse.accessToken).retry(5).accept("application/json").createConnection();
        if (request.getResponseCode() != 200) {
            throw new ResponseCodeException("https://api.minecraftservices.com/entitlements/mcstore", request.getResponseCode());
        }
        MinecraftProfileResponse profileResponse = MicrosoftService.getMinecraftProfile(minecraftResponse.tokenType, minecraftResponse.accessToken);
        MicrosoftService.handleErrorResponse(profileResponse);
        return new MicrosoftSession(minecraftResponse.tokenType, minecraftResponse.accessToken, notAfter, liveRefreshToken, new MicrosoftSession.User(minecraftResponse.username), new MicrosoftSession.GameProfile(profileResponse.id, profileResponse.name));
    }

    public Optional<MinecraftProfileResponse> getCompleteProfile(String authorization) throws AuthenticationException {
        try {
            return Optional.ofNullable(HttpRequest.GET("https://api.minecraftservices.com/minecraft/profile").authorization(authorization).getJson(MinecraftProfileResponse.class));
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    public boolean validate(long notAfter, String tokenType, String accessToken) throws AuthenticationException {
        Objects.requireNonNull(tokenType);
        Objects.requireNonNull(accessToken);
        if (System.currentTimeMillis() > notAfter) {
            return false;
        }
        try {
            MicrosoftService.getMinecraftProfile(tokenType, accessToken);
            return true;
        }
        catch (ResponseCodeException e) {
            return false;
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
    }

    private static void handleErrorResponse(MinecraftErrorResponse response) throws AuthenticationException {
        if (response.error != null) {
            throw new RemoteAuthenticationException(response.error, response.errorMessage, response.developerMessage);
        }
    }

    public static Optional<Map<TextureType, Texture>> getTextures(MinecraftProfileResponse profile) {
        Objects.requireNonNull(profile);
        EnumMap<TextureType, Texture> textures = new EnumMap<TextureType, Texture>(TextureType.class);
        if (!profile.skins.isEmpty()) {
            textures.put(TextureType.SKIN, new Texture(profile.skins.get((int)0).url, null));
        }
        return Optional.of(textures);
    }

    private static void getXBoxProfile(String uhs, String xstsToken) throws IOException {
        HttpRequest.GET("https://profile.xboxlive.com/users/me/profile/settings", Pair.pair("settings", "GameDisplayName,AppDisplayName,AppDisplayPicRaw,GameDisplayPicRaw,PublicGamerpic,ShowUserAsAvatar,Gamerscore,Gamertag,ModernGamertag,ModernGamertagSuffix,UniqueModernGamertag,AccountTier,TenureLevel,XboxOneRep,PreferredColor,Location,Bio,Watermarks,RealName,RealNameOverride,IsQuarantined")).accept("application/json").authorization(String.format("XBL3.0 x=%s;%s", uhs, xstsToken)).header("x-xbl-contract-version", "3").getString();
    }

    private static MinecraftProfileResponse getMinecraftProfile(String tokenType, String accessToken) throws IOException, AuthenticationException {
        HttpURLConnection conn = HttpRequest.GET("https://api.minecraftservices.com/minecraft/profile").authorization(tokenType, accessToken).createConnection();
        int responseCode = conn.getResponseCode();
        if (responseCode == 404) {
            throw new NoMinecraftJavaEditionProfileException();
        }
        if (responseCode != 200) {
            throw new ResponseCodeException("https://api.minecraftservices.com/minecraft/profile", responseCode);
        }
        String result = NetworkUtils.readFullyAsString(conn);
        return JsonUtils.fromNonNullJson(result, MinecraftProfileResponse.class);
    }

    public Optional<CompleteGameProfile> getCompleteGameProfile(UUID uuid) throws AuthenticationException {
        Objects.requireNonNull(uuid);
        return Optional.ofNullable(GSON.fromJson(MicrosoftService.request("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID(uuid), null), CompleteGameProfile.class));
    }

    public void uploadSkin(String accessToken, boolean isSlim, Path file) throws AuthenticationException, UnsupportedOperationException {
        try {
            HttpURLConnection con = NetworkUtils.createHttpConnection("https://api.minecraftservices.com/minecraft/profile/skins");
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + accessToken);
            con.setDoOutput(true);
            try (HttpMultipartRequest request = new HttpMultipartRequest(con);){
                request.param("variant", isSlim ? "slim" : "classic");
                try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                    request.file("file", FileUtils.getName(file), "image/" + FileUtils.getExtension(file), fis);
                }
            }
            String response = NetworkUtils.readFullyAsString(con);
            if (StringUtils.isBlank(response)) {
                if (con.getResponseCode() / 100 != 2) {
                    throw new ResponseCodeException(con.getURL().toURI(), con.getResponseCode());
                }
            } else {
                MinecraftErrorResponse profileResponse = GSON.fromJson(response, MinecraftErrorResponse.class);
                if (StringUtils.isNotBlank(profileResponse.errorMessage) || con.getResponseCode() / 100 != 2) {
                    throw new AuthenticationException("Failed to upload skin, response code: " + con.getResponseCode() + ", response: " + response);
                }
            }
        }
        catch (JsonParseException | IOException | URISyntaxException e) {
            throw new AuthenticationException(e);
        }
    }

    private static String request(String url, Object payload) throws AuthenticationException {
        try {
            if (payload == null) {
                return NetworkUtils.doGet(url);
            }
            return NetworkUtils.doPost(NetworkUtils.toURI(url), payload instanceof String ? (String)payload : GSON.toJson(payload), "application/json");
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
    }

    private static final class XBoxLiveAuthenticationResponse
    extends MicrosoftErrorResponse {
        @SerializedName(value="IssueInstant")
        String issueInstant;
        @SerializedName(value="NotAfter")
        String notAfter;
        @SerializedName(value="Token")
        String token;
        @SerializedName(value="DisplayClaims")
        XBoxLiveAuthenticationResponseDisplayClaims displayClaims;

        private XBoxLiveAuthenticationResponse() {
        }
    }

    public static class XboxAuthorizationException
    extends AuthenticationException {
        private final long errorCode;
        private final String redirect;
        public static final long BANNED = 2148916227L;
        public static final long MISSING_XBOX_ACCOUNT = 2148916233L;
        public static final long COUNTRY_UNAVAILABLE = 2148916235L;
        public static final long ADD_FAMILY = 2148916238L;

        public XboxAuthorizationException(long errorCode, String redirect) {
            this.errorCode = errorCode;
            this.redirect = redirect;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public String getRedirect() {
            return this.redirect;
        }
    }

    private static final class XBoxLiveAuthenticationResponseDisplayClaims {
        List<Map<Object, Object>> xui;

        private XBoxLiveAuthenticationResponseDisplayClaims() {
        }
    }

    public static final class NoXuiException
    extends AuthenticationException {
    }

    public static final class XBox400Exception
    extends AuthenticationException {
    }

    private static final class MinecraftLoginWithXBoxResponse {
        @SerializedName(value="username")
        String username;
        @SerializedName(value="roles")
        List<String> roles;
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="token_type")
        String tokenType;
        @SerializedName(value="expires_in")
        int expiresIn;

        private MinecraftLoginWithXBoxResponse() {
        }
    }

    public static class MinecraftProfileResponse
    extends MinecraftErrorResponse
    implements Validation {
        @SerializedName(value="id")
        UUID id;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="skins")
        List<MinecraftProfileResponseSkin> skins;
        @SerializedName(value="capes")
        List<MinecraftProfileResponseCape> capes;

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            Validation.requireNonNull(this.id, "id cannot be null");
            Validation.requireNonNull(this.name, "name cannot be null");
            Validation.requireNonNull(this.skins, "skins cannot be null");
            Validation.requireNonNull(this.capes, "capes cannot be null");
        }
    }

    private static class MinecraftErrorResponse {
        public String path;
        public String errorType;
        public String error;
        public String errorMessage;
        public String developerMessage;

        private MinecraftErrorResponse() {
        }
    }

    public static final class MinecraftProfileResponseSkin
    implements Validation {
        public String id;
        public String state;
        public String url;
        public String variant;
        public String alias;

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            Validation.requireNonNull(this.id, "id cannot be null");
            Validation.requireNonNull(this.state, "state cannot be null");
            Validation.requireNonNull(this.url, "url cannot be null");
            Validation.requireNonNull(this.variant, "variant cannot be null");
        }
    }

    public static final class NoMinecraftJavaEditionProfileException
    extends AuthenticationException {
    }

    public static class MinecraftProfileResponseCape {
    }

    private static final class MinecraftStoreResponse
    extends MinecraftErrorResponse {
        @SerializedName(value="items")
        List<MinecraftStoreResponseItem> items;
        @SerializedName(value="signature")
        String signature;
        @SerializedName(value="keyId")
        String keyId;

        private MinecraftStoreResponse() {
        }
    }

    private static final class MinecraftStoreResponseItem {
        @SerializedName(value="name")
        String name;
        @SerializedName(value="signature")
        String signature;

        private MinecraftStoreResponseItem() {
        }
    }

    private static class MicrosoftErrorResponse {
        @SerializedName(value="XErr")
        long errorCode;
        @SerializedName(value="Message")
        String message;
        @SerializedName(value="Redirect")
        String redirectUrl;

        private MicrosoftErrorResponse() {
        }
    }
}

