/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.SimpleMultimap;

public abstract class VersionList<T extends RemoteVersion> {
    protected final SimpleMultimap<String, T, TreeSet<T>> versions = new SimpleMultimap(HashMap::new, TreeSet::new);
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public boolean isLoaded() {
        return !this.versions.isEmpty();
    }

    public boolean isLoaded(String gameVersion) {
        return !this.versions.get(gameVersion).isEmpty();
    }

    public abstract boolean hasType();

    public abstract Task<?> refreshAsync();

    public Task<?> refreshAsync(String gameVersion) {
        return this.refreshAsync();
    }

    public Task<?> loadAsync(String gameVersion) {
        return Task.composeAsync(() -> {
            this.lock.readLock().lock();
            try {
                Task<?> task = this.isLoaded(gameVersion) ? null : this.refreshAsync(gameVersion);
                return task;
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    protected Collection<T> getVersionsImpl(String gameVersion) {
        return this.versions.get(gameVersion);
    }

    public final Collection<T> getVersions(String gameVersion) {
        this.lock.readLock().lock();
        try {
            Collection<T> collection = Collections.unmodifiableCollection(new ArrayList<T>(this.getVersionsImpl(gameVersion)));
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getVersion(String gameVersion, String remoteVersion) {
        this.lock.readLock().lock();
        try {
            RemoteVersion result = null;
            TreeSet<T> remoteVersions = this.versions.get(gameVersion);
            for (RemoteVersion it : remoteVersions) {
                if (!remoteVersion.equals(it.getSelfVersion())) continue;
                result = it;
            }
            if (result == null) {
                for (RemoteVersion it : remoteVersions) {
                    if (!remoteVersion.equals(it.getFullVersion())) continue;
                    result = it;
                }
            }
            Optional<Object> optional = Optional.ofNullable(result);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

