/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.event;

import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventPriority;
import org.jackhuang.hmcl.util.SimpleMultimap;
import org.jetbrains.annotations.Contract;

public final class EventManager<T extends Event> {
    private final ReentrantLock lock = new ReentrantLock();
    private final SimpleMultimap<EventPriority, Consumer<T>, CopyOnWriteArraySet<Consumer<T>>> handlers = new SimpleMultimap(() -> new EnumMap(EventPriority.class), CopyOnWriteArraySet::new);

    @Contract(value="_ -> param1")
    public Consumer<T> registerWeak(Consumer<T> consumer) {
        this.register(new WeakListener(consumer));
        return consumer;
    }

    @Contract(value="_, _ -> param1")
    public Consumer<T> registerWeak(Consumer<T> consumer, EventPriority priority) {
        this.register(new WeakListener(consumer), priority);
        return consumer;
    }

    public void register(Consumer<T> consumer) {
        this.register(consumer, EventPriority.NORMAL);
    }

    public void register(Consumer<T> consumer, EventPriority priority) {
        this.lock.lock();
        try {
            this.handlers.get(priority).add(consumer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void register(Runnable runnable) {
        this.register((T t) -> runnable.run());
    }

    public void register(Runnable runnable, EventPriority priority) {
        this.register((T t) -> runnable.run(), priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event.Result fireEvent(T event) {
        this.lock.lock();
        try {
            for (EventPriority priority : EventPriority.values()) {
                for (Consumer<T> handler : this.handlers.get(priority)) {
                    handler.accept(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return ((Event)event).hasResult() ? ((Event)event).getResult() : Event.Result.DEFAULT;
    }

    public void unregister(Consumer<T> consumer) {
        this.lock.lock();
        try {
            this.handlers.removeValue(consumer);
        }
        finally {
            this.lock.unlock();
        }
    }

    private final class WeakListener
    implements Consumer<T> {
        private final WeakReference<Consumer<T>> ref;

        public WeakListener(Consumer<T> listener) {
            this.ref = new WeakReference(listener);
        }

        @Override
        public void accept(T t) {
            Consumer listener = (Consumer)this.ref.get();
            if (listener == null) {
                EventManager.this.unregister(this);
            } else {
                listener.accept(t);
            }
        }
    }
}

