/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.resourcepack;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.resourcepack.ResourcepackFolder;
import org.jackhuang.hmcl.resourcepack.ResourcepackZipFile;
import org.jetbrains.annotations.Nullable;

public interface ResourcepackFile {
    @Nullable
    public LocalModFile.Description getDescription();

    public String getName();

    public Path getPath();

    public byte @Nullable [] getIcon();

    public static ResourcepackFile parse(Path path) throws IOException {
        String fileName = path.getFileName().toString();
        if (Files.isRegularFile(path, new LinkOption[0]) && fileName.toLowerCase(Locale.ROOT).endsWith(".zip")) {
            return new ResourcepackZipFile(path);
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("pack.mcmeta"), new LinkOption[0])) {
            return new ResourcepackFolder(path);
        }
        return null;
    }
}

