/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorRole;
import org.glavo.monetfx.ColorScheme;
import org.jackhuang.hmcl.setting.FontManager;
import org.jackhuang.hmcl.theme.Theme;
import org.jackhuang.hmcl.theme.ThemeColor;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class StyleSheets {
    private static final int FONT_STYLE_SHEET_INDEX = 0;
    private static final int THEME_STYLE_SHEET_INDEX = 1;
    private static final int BRIGHTNESS_SHEET_INDEX = 2;
    private static final ObservableList<String> stylesheets;

    private static String toStyleSheetUri(String styleSheet, String fallback) {
        if (FXUtils.JAVAFX_MAJOR_VERSION >= 17) {
            return "data:text/css;charset=UTF-8;base64," + Base64.getEncoder().encodeToString(styleSheet.getBytes(StandardCharsets.UTF_8));
        }
        try {
            Path temp = Files.createTempFile("hmcl", ".css", new FileAttribute[0]);
            Files.writeString(temp, (CharSequence)styleSheet, Charset.defaultCharset(), new OpenOption[0]);
            temp.toFile().deleteOnExit();
            return temp.toUri().toString();
        }
        catch (IOException | NullPointerException e) {
            Logger.LOG.error("Unable to create stylesheet, fallback to " + fallback, e);
            return fallback;
        }
    }

    private static String getFontStyleSheet() {
        String defaultCss = "/assets/css/font.css";
        FontManager.FontReference font = FontManager.getFont();
        if (font == null || "System".equals(font.getFamily())) {
            return "/assets/css/font.css";
        }
        String fontFamily = font.getFamily();
        String style = font.getStyle();
        String weight = null;
        String posture = null;
        if (style != null) {
            if ((style = style.toLowerCase(Locale.ROOT)).contains("thin")) {
                weight = "100";
            } else if (style.contains("extralight") || style.contains("extra light") || style.contains("ultralight") | style.contains("ultra light")) {
                weight = "200";
            } else if (style.contains("medium")) {
                weight = "500";
            } else if (style.contains("semibold") || style.contains("semi bold") || style.contains("demibold") || style.contains("demi bold")) {
                weight = "600";
            } else if (style.contains("extrabold") || style.contains("extra bold") || style.contains("ultrabold") || style.contains("ultra bold")) {
                weight = "800";
            } else if (style.contains("black") || style.contains("heavy")) {
                weight = "900";
            } else if (style.contains("light")) {
                weight = "lighter";
            } else if (style.contains("bold")) {
                weight = "bold";
            }
            posture = style.contains("italic") || style.contains("oblique") ? "italic" : null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(".root {");
        builder.append("-fx-font-family:\"").append(fontFamily).append("\";");
        if (weight != null) {
            builder.append("-fx-font-weight:").append(weight).append(";");
        }
        if (posture != null) {
            builder.append("-fx-font-style:").append(posture).append(";");
        }
        builder.append('}');
        return StyleSheets.toStyleSheetUri(builder.toString(), "/assets/css/font.css");
    }

    private static String getBrightnessStyleSheet() {
        return Themes.getColorScheme().getBrightness() == Brightness.LIGHT ? "/assets/css/brightness-light.css" : "/assets/css/brightness-dark.css";
    }

    private static void addColor(StringBuilder builder, String name, Color color) {
        builder.append("  ").append(name).append(": ").append(ThemeColor.getColorDisplayName(color)).append(";\n");
    }

    private static void addColor(StringBuilder builder, String name, Color color, double opacity) {
        builder.append("  ").append(name).append(": ").append(ThemeColor.getColorDisplayNameWithOpacity(color, opacity)).append(";\n");
    }

    private static void addColor(StringBuilder builder, ColorScheme scheme, ColorRole role, double opacity) {
        builder.append("  ").append(role.getVariableName()).append("-transparent-%02d".formatted((int)(100.0 * opacity))).append(": ").append(ThemeColor.getColorDisplayNameWithOpacity(scheme.getColor(role), opacity)).append(";\n");
    }

    private static String getThemeStyleSheet() {
        String blueCss = "/assets/css/blue.css";
        if (Theme.DEFAULT.equals(Themes.getTheme())) {
            return "/assets/css/blue.css";
        }
        ColorScheme scheme = Themes.getColorScheme();
        StringBuilder builder = new StringBuilder();
        builder.append("* {\n");
        for (ColorRole colorRole : ColorRole.ALL) {
            StyleSheets.addColor(builder, colorRole.getVariableName(), scheme.getColor(colorRole));
        }
        StyleSheets.addColor(builder, "-monet-primary-seed", scheme.getPrimaryColorSeed());
        StyleSheets.addColor(builder, scheme, ColorRole.PRIMARY, 0.5);
        StyleSheets.addColor(builder, scheme, ColorRole.SECONDARY_CONTAINER, 0.5);
        StyleSheets.addColor(builder, scheme, ColorRole.SURFACE, 0.5);
        StyleSheets.addColor(builder, scheme, ColorRole.SURFACE, 0.8);
        StyleSheets.addColor(builder, scheme, ColorRole.ON_SURFACE_VARIANT, 0.38);
        StyleSheets.addColor(builder, scheme, ColorRole.SURFACE_CONTAINER_LOW, 0.8);
        StyleSheets.addColor(builder, scheme, ColorRole.SECONDARY_CONTAINER, 0.8);
        StyleSheets.addColor(builder, scheme, ColorRole.INVERSE_SURFACE, 0.8);
        builder.append("}\n");
        return StyleSheets.toStyleSheetUri(builder.toString(), "/assets/css/blue.css");
    }

    public static void init(Scene scene) {
        Bindings.bindContent((List)scene.getStylesheets(), stylesheets);
    }

    private StyleSheets() {
    }

    static {
        String[] array = new String[]{StyleSheets.getFontStyleSheet(), StyleSheets.getThemeStyleSheet(), StyleSheets.getBrightnessStyleSheet(), "/assets/css/root.css"};
        stylesheets = FXCollections.observableList(Arrays.asList(array));
        FontManager.fontProperty().addListener(o -> stylesheets.set(0, (Object)StyleSheets.getFontStyleSheet()));
        Themes.colorSchemeProperty().addListener(o -> {
            stylesheets.set(1, (Object)StyleSheets.getThemeStyleSheet());
            stylesheets.set(2, (Object)StyleSheets.getBrightnessStyleSheet());
        });
    }
}

