/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaNative;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jetbrains.annotations.Nullable;

public final class GeneralProvider
implements ITerracottaProvider {
    private final TerracottaNative target;

    public GeneralProvider(TerracottaNative target) {
        this.target = target;
    }

    @Override
    public ITerracottaProvider.Status status() throws IOException {
        return this.target.status();
    }

    @Override
    public Task<?> install(ITerracottaProvider.Context context, @Nullable TarFileTree tree) throws IOException {
        Task<Object> task = this.target.install(context, tree);
        context.bindProgress((ObservableValue<? extends Number>)task.progressProperty());
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
            task = task.thenRunAsync(() -> Files.setPosixFilePermissions(this.target.getPath(), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE)));
        }
        return task;
    }

    @Override
    public List<String> ofCommandLine(Path path) {
        return List.of(this.target.getPath().toString(), "--hmcl", path.toString());
    }
}

