/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXTextField;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.DownloadPage;
import org.jackhuang.hmcl.ui.versions.HMCLLocalizedDownloadListPage;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

final class ModListPageSkin
extends SkinBase<ModListPage> {
    private final TransitionPane toolbarPane;
    private final HBox searchBar;
    private final HBox toolbarNormal;
    private final HBox toolbarSelecting;
    private final JFXListView<ModInfoObject> listView;
    private final JFXTextField searchField;
    private boolean isSearching = false;
    private final ChangeListener<Boolean> holder;
    private static final Lazy<PopupMenu> menu = new Lazy<PopupMenu>(PopupMenu::new);
    private static final Lazy<JFXPopup> popup = new Lazy<JFXPopup>(() -> new JFXPopup((Region)menu.get()));

    ModListPageSkin(ModListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0));
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        this.listView = new JFXListView();
        this.holder = FXUtils.onWeakChange(skinnable.loadingProperty(), loading -> {
            if (!loading.booleanValue()) {
                this.listView.scrollTo(0);
            }
        });
        this.toolbarPane = new TransitionPane();
        this.searchBar = new HBox();
        this.toolbarNormal = new HBox();
        this.toolbarSelecting = new HBox();
        this.searchBar.setAlignment(Pos.CENTER);
        this.searchBar.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.searchField = new JFXTextField();
        this.searchField.setPromptText(I18n.i18n("search"));
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
        pause.setOnFinished(e -> this.search());
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            pause.setRate(1.0);
            pause.playFromStart();
        });
        JFXButton closeSearchBar = ToolbarListPageSkin.createToolbarButton2(null, SVG.CLOSE, () -> {
            this.changeToolbar(this.toolbarNormal);
            this.isSearching = false;
            this.searchField.clear();
            Bindings.bindContent((List)this.listView.getItems(), ((ModListPage)this.getSkinnable()).getItems());
        });
        FXUtils.onEscPressed((Node)this.searchField, () -> ((JFXButton)closeSearchBar).fire());
        this.searchBar.getChildren().setAll((Object[])new Node[]{this.searchField, closeSearchBar});
        Object[] objectArray = new Node[6];
        objectArray[0] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
        objectArray[1] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.add"), SVG.ADD, skinnable::add);
        objectArray[2] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.reveal_dir"), SVG.FOLDER_OPEN, skinnable::openModFolder);
        objectArray[3] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.check_updates.button"), SVG.UPDATE, skinnable::checkUpdates);
        objectArray[4] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("download"), SVG.DOWNLOAD, skinnable::download);
        objectArray[5] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("search"), SVG.SEARCH, () -> this.changeToolbar(this.searchBar));
        this.toolbarNormal.getChildren().setAll(objectArray);
        this.toolbarSelecting.getChildren().setAll((Object[])new Node[]{ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.remove"), SVG.DELETE, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems()), null)), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.enable"), SVG.CHECK, () -> skinnable.enableSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.disable"), SVG.CLOSE, () -> skinnable.disableSelected((ObservableList<ModInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.select_all"), SVG.SELECT_ALL, () -> this.listView.getSelectionModel().selectAll()), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.cancel"), SVG.CANCEL, () -> this.listView.getSelectionModel().clearSelection())});
        FXUtils.onChangeAndOperate(this.listView.getSelectionModel().selectedItemProperty(), selectedItem -> {
            if (selectedItem == null) {
                this.changeToolbar(this.isSearching ? this.searchBar : this.toolbarNormal);
            } else {
                this.changeToolbar(this.toolbarSelecting);
            }
        });
        root.getContent().add((Object)this.toolbarPane);
        root.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.listView.getSelectionModel().getSelectedItem() != null) {
                this.listView.getSelectionModel().clearSelection();
                e.consume();
            }
        });
        SpinnerPane center = new SpinnerPane();
        ComponentList.setVgrow((Node)center, Priority.ALWAYS);
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        Holder lastCell = new Holder();
        this.listView.setCellFactory(x -> new ModInfoListCell(this.listView, lastCell));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)this.listView.getItems(), skinnable.getItems());
        skinnable.getItems().addListener(c -> {
            if (this.isSearching) {
                this.search();
            }
        });
        this.listView.setOnContextMenuRequested(event -> {
            ModInfoObject selectedItem = (ModInfoObject)this.listView.getSelectionModel().getSelectedItem();
            if (selectedItem != null && this.listView.getSelectionModel().getSelectedItems().size() == 1) {
                this.listView.getSelectionModel().clearSelection();
                Controllers.dialog((Region)new ModInfoDialog(selectedItem));
            }
        });
        FXUtils.ignoreEvent(this.listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
        center.setContent((Node)this.listView);
        root.getContent().add((Object)center);
        Label label = new Label(I18n.i18n("mods.not_modded"));
        label.prefWidthProperty().bind((ObservableValue)pane.widthProperty().add(-100));
        FXUtils.onChangeAndOperate(skinnable.moddedProperty(), modded -> {
            if (modded.booleanValue()) {
                pane.getChildren().setAll((Object[])new Node[]{root});
            } else {
                pane.getChildren().setAll((Object[])new Node[]{label});
            }
        });
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    private void changeToolbar(HBox newToolbar) {
        Node oldToolbar = this.toolbarPane.getCurrentNode();
        if (newToolbar != oldToolbar) {
            this.toolbarPane.setContent((Node)newToolbar, ContainerAnimations.FADE);
            if (newToolbar == this.searchBar) {
                Platform.runLater(() -> ((JFXTextField)this.searchField).requestFocus());
            }
        }
    }

    private void search() {
        this.isSearching = true;
        Bindings.unbindContent((Object)this.listView.getItems(), ((ModListPage)this.getSkinnable()).getItems());
        String queryString = this.searchField.getText();
        if (StringUtils.isBlank(queryString)) {
            this.listView.getItems().setAll(((ModListPage)this.getSkinnable()).getItems());
        } else {
            Predicate<String> predicate;
            this.listView.getItems().clear();
            if (queryString.startsWith("regex:")) {
                try {
                    Pattern pattern = Pattern.compile(queryString.substring("regex:".length()));
                    predicate = s -> s != null && pattern.matcher((CharSequence)s).find();
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Illegal regular expression", e);
                    return;
                }
            } else {
                String lowerQueryString = queryString.toLowerCase(Locale.ROOT);
                predicate = s -> s != null && s.toLowerCase(Locale.ROOT).contains(lowerQueryString);
            }
            for (ModInfoObject item : ((ModListPage)this.getSkinnable()).getItems()) {
                LocalModFile modInfo = item.getModInfo();
                if (!predicate.test(modInfo.getFileName()) && !predicate.test(modInfo.getName()) && !predicate.test(modInfo.getVersion()) && !predicate.test(modInfo.getGameVersion()) && !predicate.test(modInfo.getId()) && !predicate.test(Objects.toString((Object)modInfo.getModLoaderType())) && !predicate.test(item.getModTranslations() != null ? item.getModTranslations().getDisplayName() : null)) continue;
                this.listView.getItems().add((Object)item);
            }
        }
    }

    static final class ModInfoObject {
        private final BooleanProperty active;
        private final LocalModFile localModFile;
        @Nullable
        private final ModTranslations.Mod modTranslations;
        private SoftReference<CompletableFuture<Image>> iconCache;

        ModInfoObject(LocalModFile localModFile) {
            this.localModFile = localModFile;
            this.active = localModFile.activeProperty();
            this.modTranslations = ModTranslations.MOD.getMod(localModFile.getId(), localModFile.getName());
        }

        LocalModFile getModInfo() {
            return this.localModFile;
        }

        @Nullable
        public ModTranslations.Mod getModTranslations() {
            return this.modTranslations;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Image loadIcon() {
            ArrayList<String> iconPaths = new ArrayList<String>();
            if (StringUtils.isNotBlank(this.localModFile.getLogoPath())) {
                iconPaths.add(this.localModFile.getLogoPath());
            }
            iconPaths.addAll(List.of("icon.png", "logo.png", "mod_logo.png", "pack.png", "logoFile.png", "assets/icon.png", "assets/logo.png", "assets/mod_icon.png", "assets/mod_logo.png", "META-INF/icon.png", "META-INF/logo.png", "META-INF/mod_icon.png", "textures/icon.png", "textures/logo.png", "textures/mod_icon.png", "resources/icon.png", "resources/logo.png", "resources/mod_icon.png"));
            String modId = this.localModFile.getId();
            if (StringUtils.isNotBlank(modId)) {
                iconPaths.addAll(List.of("assets/" + modId + "/icon.png", "assets/" + modId + "/logo.png", "assets/" + modId.replace("-", "") + "/icon.png", "assets/" + modId.replace("-", "") + "/logo.png", modId + ".png", modId + "-logo.png", modId + "-icon.png", modId + "_logo.png", modId + "_icon.png", "textures/" + modId + "/icon.png", "textures/" + modId + "/logo.png", "resources/" + modId + "/icon.png", "resources/" + modId + "/logo.png"));
            }
            try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.localModFile.getFile());){
                Image image;
                String path;
                Path iconPath;
                Iterator iterator = iconPaths.iterator();
                do {
                    if (!iterator.hasNext()) return VersionIconType.getIconType(this.localModFile.getModLoaderType()).getIcon();
                } while (!Files.exists(iconPath = fs.getPath(path = (String)iterator.next(), new String[0]), new LinkOption[0]) || (image = FXUtils.loadImage(iconPath, 80, 80, true, true)).isError() || !(image.getWidth() > 0.0) || !(image.getHeight() > 0.0) || !(Math.abs(image.getWidth() - image.getHeight()) < 1.0));
                Image image2 = image;
                return image2;
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to load mod icons", e);
            }
            return VersionIconType.getIconType(this.localModFile.getModLoaderType()).getIcon();
        }

        public void loadIcon(ImageView imageView, @Nullable WeakReference<ObjectProperty<ModInfoObject>> current) {
            CompletableFuture<Image> imageFuture;
            SoftReference<CompletableFuture<Image>> iconCache = this.iconCache;
            if (iconCache != null && (imageFuture = iconCache.get()) != null) {
                Image image2 = imageFuture.getNow(null);
                if (image2 != null) {
                    imageView.setImage(image2);
                    return;
                }
            } else {
                imageFuture = CompletableFuture.supplyAsync(this::loadIcon, Schedulers.io());
                this.iconCache = new SoftReference<CompletableFuture<Image>>(imageFuture);
            }
            imageView.setImage(VersionIconType.getIconType(this.localModFile.getModLoaderType()).getIcon());
            imageFuture.thenAcceptAsync(image -> {
                ObjectProperty infoObjectProperty;
                if (current != null && ((infoObjectProperty = (ObjectProperty)current.get()) == null || infoObjectProperty.get() != this)) {
                    return;
                }
                imageView.setImage(image);
            }, Schedulers.javafx());
        }
    }

    final class ModInfoDialog
    extends JFXDialogLayout {
        ModInfoDialog(ModInfoObject modInfo) {
            HBox titleContainer = new HBox();
            titleContainer.setSpacing(8.0);
            Stage stage = Controllers.getStage();
            this.maxWidthProperty().bind((ObservableValue)stage.widthProperty().multiply(0.7));
            ImageView imageView = new ImageView();
            FXUtils.limitSize(imageView, 40.0, 40.0);
            modInfo.loadIcon(imageView, null);
            TwoLineListItem title = new TwoLineListItem();
            if (modInfo.getModTranslations() != null && I18n.isUseChinese()) {
                title.setTitle(modInfo.getModTranslations().getDisplayName());
            } else {
                title.setTitle(modInfo.getModInfo().getName());
            }
            StringJoiner subtitle = new StringJoiner(" | ");
            subtitle.add(FileUtils.getName(modInfo.getModInfo().getFile()));
            if (StringUtils.isNotBlank(modInfo.getModInfo().getGameVersion())) {
                subtitle.add(modInfo.getModInfo().getGameVersion());
            }
            if (StringUtils.isNotBlank(modInfo.getModInfo().getVersion())) {
                subtitle.add(modInfo.getModInfo().getVersion());
            }
            if (StringUtils.isNotBlank(modInfo.getModInfo().getAuthors())) {
                subtitle.add(I18n.i18n("archive.author") + ": " + modInfo.getModInfo().getAuthors());
            }
            title.setSubtitle(subtitle.toString());
            titleContainer.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)imageView, 40.0, 40.0), title});
            this.setHeading(new Node[]{titleContainer});
            Label description = new Label(modInfo.getModInfo().getDescription().toString());
            description.setWrapText(true);
            FXUtils.copyOnDoubleClick((Labeled)description);
            ScrollPane descriptionPane = new ScrollPane((Node)description);
            FXUtils.smoothScrolling(descriptionPane);
            descriptionPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            descriptionPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            descriptionPane.setFitToWidth(true);
            description.heightProperty().addListener((obs, oldVal, newVal) -> {
                double maxHeight = stage.getHeight() * 0.5;
                double targetHeight = Math.min(newVal.doubleValue(), maxHeight);
                descriptionPane.setPrefViewportHeight(targetHeight);
            });
            this.setBody(new Node[]{descriptionPane});
            if (StringUtils.isNotBlank(modInfo.getModInfo().getId())) {
                for (Pair item : Arrays.asList(Pair.pair("mods.curseforge", CurseForgeRemoteModRepository.MODS), Pair.pair("mods.modrinth", ModrinthRemoteModRepository.MODS))) {
                    RemoteModRepository repository = (RemoteModRepository)item.getValue();
                    JFXHyperlink button = new JFXHyperlink(I18n.i18n((String)item.getKey()));
                    Task.runAsync(() -> {
                        Optional<RemoteMod.Version> versionOptional = repository.getRemoteVersionByLocalFile(modInfo.getModInfo(), modInfo.getModInfo().getFile());
                        if (versionOptional.isPresent()) {
                            RemoteMod remoteMod = repository.getModById(versionOptional.get().getModid());
                            FXUtils.runInFX(() -> {
                                block8: for (ModLoaderType modLoaderType : ((RemoteMod.Version)versionOptional.get()).getLoaders()) {
                                    String loaderName;
                                    switch (modLoaderType) {
                                        case FORGE: {
                                            loaderName = I18n.i18n("install.installer.forge");
                                            break;
                                        }
                                        case CLEANROOM: {
                                            loaderName = I18n.i18n("install.installer.cleanroom");
                                            break;
                                        }
                                        case NEO_FORGED: {
                                            loaderName = I18n.i18n("install.installer.neoforge");
                                            break;
                                        }
                                        case FABRIC: {
                                            loaderName = I18n.i18n("install.installer.fabric");
                                            break;
                                        }
                                        case LITE_LOADER: {
                                            loaderName = I18n.i18n("install.installer.liteloader");
                                            break;
                                        }
                                        case QUILT: {
                                            loaderName = I18n.i18n("install.installer.quilt");
                                            break;
                                        }
                                        default: {
                                            continue block8;
                                        }
                                    }
                                    if (!title.getTags().stream().noneMatch(it -> it.getText().equals(loaderName))) continue;
                                    title.addTag(loaderName);
                                }
                                button.setOnAction(e -> {
                                    this.fireEvent(new DialogCloseEvent());
                                    Controllers.navigate((Node)new DownloadPage(repository instanceof CurseForgeRemoteModRepository ? HMCLLocalizedDownloadListPage.ofCurseForgeMod(null, false) : HMCLLocalizedDownloadListPage.ofModrinthMod(null, false), remoteMod, new Profile.ProfileVersion(((ModListPage)ModListPageSkin.this.getSkinnable()).getProfile(), ((ModListPage)ModListPageSkin.this.getSkinnable()).getInstanceId()), (profile, version, file) -> org.jackhuang.hmcl.ui.download.DownloadPage.download(profile, version, file, "mods")));
                                });
                                button.setDisable(false);
                            });
                        }
                    }).start();
                    button.setDisable(true);
                    this.getActions().add((Object)button);
                }
            }
            if (StringUtils.isNotBlank(modInfo.getModInfo().getUrl())) {
                JFXHyperlink officialPageButton = new JFXHyperlink(I18n.i18n("mods.url"));
                officialPageButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(modInfo.getModInfo().getUrl());
                });
                this.getActions().add((Object)officialPageButton);
            }
            if (modInfo.getModTranslations() == null || StringUtils.isBlank(modInfo.getModTranslations().getMcmod())) {
                JFXHyperlink searchButton = new JFXHyperlink(I18n.i18n("mods.mcmod.search"));
                searchButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(NetworkUtils.withQuery("https://search.mcmod.cn/s", Lang.mapOf(Pair.pair("key", modInfo.getModInfo().getName()), Pair.pair("site", "all"), Pair.pair("filter", "0"))));
                });
                this.getActions().add((Object)searchButton);
            } else {
                JFXHyperlink mcmodButton = new JFXHyperlink(I18n.i18n("mods.mcmod.page"));
                mcmodButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(ModTranslations.MOD.getMcmodUrl(modInfo.getModTranslations()));
                });
                this.getActions().add((Object)mcmodButton);
            }
            JFXButton okButton = new JFXButton();
            okButton.getStyleClass().add((Object)"dialog-accept");
            okButton.setText(I18n.i18n("button.ok"));
            okButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            this.getActions().add((Object)okButton);
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)okButton).fire());
        }
    }

    final class ModInfoListCell
    extends MDListCell<ModInfoObject> {
        private static final PseudoClass WARNING = PseudoClass.getPseudoClass((String)"warning");
        JFXCheckBox checkBox;
        ImageView imageView;
        TwoLineListItem content;
        JFXButton restoreButton;
        JFXButton infoButton;
        JFXButton revealButton;
        BooleanProperty booleanProperty;
        Tooltip warningTooltip;

        ModInfoListCell(JFXListView<ModInfoObject> listView, Holder<Object> lastCell) {
            super(listView, lastCell);
            this.checkBox = new JFXCheckBox();
            this.imageView = new ImageView();
            this.content = new TwoLineListItem();
            this.restoreButton = new JFXButton();
            this.infoButton = new JFXButton();
            this.revealButton = new JFXButton();
            this.getStyleClass().add((Object)"mod-info-list-cell");
            HBox container = new HBox(8.0);
            container.setPickOnBounds(false);
            container.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.content.setMouseTransparent(true);
            this.setSelectable();
            this.imageView.setFitWidth(24.0);
            this.imageView.setFitHeight(24.0);
            this.imageView.setPreserveRatio(true);
            this.imageView.setImage(VersionIconType.COMMAND.getIcon());
            this.restoreButton.getStyleClass().add((Object)"toggle-icon4");
            this.restoreButton.setGraphic(FXUtils.limitingSize(SVG.RESTORE.createIcon(24.0), 24.0, 24.0));
            FXUtils.installFastTooltip((Node)this.restoreButton, I18n.i18n("mods.restore"));
            this.revealButton.getStyleClass().add((Object)"toggle-icon4");
            this.revealButton.setGraphic(FXUtils.limitingSize(SVG.FOLDER.createIcon(24.0), 24.0, 24.0));
            this.infoButton.getStyleClass().add((Object)"toggle-icon4");
            this.infoButton.setGraphic(FXUtils.limitingSize(SVG.INFO.createIcon(24.0), 24.0, 24.0));
            container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.imageView, this.content, this.restoreButton, this.revealButton, this.infoButton});
            StackPane.setMargin((Node)container, (Insets)new Insets(8.0));
            this.getContainer().getChildren().setAll((Object[])new Node[]{container});
        }

        @Override
        protected void updateControl(ModInfoObject dataItem, boolean empty) {
            String chineseName;
            this.pseudoClassStateChanged(WARNING, false);
            if (this.warningTooltip != null) {
                Tooltip.uninstall((Node)this, (Tooltip)this.warningTooltip);
                this.warningTooltip = null;
            }
            if (empty) {
                return;
            }
            ArrayList<String> warning = new ArrayList<String>();
            this.content.getTags().clear();
            LocalModFile modInfo = dataItem.getModInfo();
            ModTranslations.Mod modTranslations = dataItem.getModTranslations();
            ModLoaderType modLoaderType = modInfo.getModLoaderType();
            dataItem.loadIcon(this.imageView, new WeakReference<ObjectProperty<ModInfoObject>>(this.itemProperty()));
            Object displayName = modInfo.getName();
            if (modTranslations != null && I18n.isUseChinese() && StringUtils.containsChinese(chineseName = modTranslations.getName())) {
                if (StringUtils.containsEmoji(chineseName)) {
                    StringBuilder builder = new StringBuilder();
                    chineseName.codePoints().forEach(ch -> {
                        if (ch < 127744 || ch > 129791) {
                            builder.appendCodePoint(ch);
                        }
                    });
                    chineseName = builder.toString().trim();
                }
                if (StringUtils.isNotBlank(chineseName) && !((String)displayName).equalsIgnoreCase(chineseName)) {
                    displayName = (String)displayName + " (" + chineseName + ")";
                }
            }
            this.content.setTitle((String)displayName);
            StringJoiner joiner = new StringJoiner(" | ");
            if (modLoaderType != ModLoaderType.UNKNOWN && StringUtils.isNotBlank(modInfo.getId())) {
                joiner.add(modInfo.getId());
            }
            joiner.add(FileUtils.getName(modInfo.getFile()));
            this.content.setSubtitle(joiner.toString());
            if (modLoaderType == ModLoaderType.UNKNOWN) {
                this.content.addTagWarning(I18n.i18n("mods.unknown"));
            } else if (!((ModListPage)ModListPageSkin.this.getSkinnable()).supportedLoaders.contains((Object)modLoaderType)) {
                warning.add(I18n.i18n("mods.warning.loader_mismatch"));
                switch (dataItem.getModInfo().getModLoaderType()) {
                    case FORGE: {
                        this.content.addTagWarning(I18n.i18n("install.installer.forge"));
                        break;
                    }
                    case CLEANROOM: {
                        this.content.addTagWarning(I18n.i18n("install.installer.cleanroom"));
                        break;
                    }
                    case NEO_FORGED: {
                        this.content.addTagWarning(I18n.i18n("install.installer.neoforge"));
                        break;
                    }
                    case FABRIC: {
                        this.content.addTagWarning(I18n.i18n("install.installer.fabric"));
                        break;
                    }
                    case LITE_LOADER: {
                        this.content.addTagWarning(I18n.i18n("install.installer.liteloader"));
                        break;
                    }
                    case QUILT: {
                        this.content.addTagWarning(I18n.i18n("install.installer.quilt"));
                    }
                }
            }
            String modVersion = modInfo.getVersion();
            if (StringUtils.isNotBlank(modVersion) && !"${version}".equals(modVersion)) {
                this.content.addTag(modVersion);
            }
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            this.booleanProperty = dataItem.active;
            this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            this.restoreButton.setVisible(!modInfo.getMod().getOldFiles().isEmpty());
            this.restoreButton.setOnAction(e -> {
                menu.get().getContent().setAll(modInfo.getMod().getOldFiles().stream().map(localModFile -> new IconedMenuItem(null, localModFile.getVersion(), () -> ((ModListPage)ModListPageSkin.this.getSkinnable()).rollback(modInfo, (LocalModFile)localModFile), popup.get())).toList());
                popup.get().show((Node)this.restoreButton, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, this.restoreButton.getHeight());
            });
            this.revealButton.setOnAction(e -> FXUtils.showFileInExplorer(modInfo.getFile()));
            this.infoButton.setOnAction(e -> Controllers.dialog((Region)new ModInfoDialog(dataItem)));
            if (!warning.isEmpty()) {
                this.pseudoClassStateChanged(WARNING, true);
                this.warningTooltip = warning.size() == 1 ? new Tooltip((String)warning.get(0)) : new Tooltip(String.join((CharSequence)"\n", warning));
                FXUtils.installFastTooltip((Node)this, this.warningTooltip);
            }
        }
    }
}

