/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.game.WorldLockedException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.WorldBackupTask;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class WorldBackupsPage
extends ListPageBase<BackupInfo> {
    static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private final World world;
    private final Path backupsDir;
    private final boolean isReadOnly;
    private final Pattern backupFileNamePattern;

    public WorldBackupsPage(WorldManagePage worldManagePage) {
        this.world = worldManagePage.getWorld();
        this.backupsDir = worldManagePage.getBackupsDir();
        this.isReadOnly = worldManagePage.isReadOnly();
        this.backupFileNamePattern = Pattern.compile("(?<datetime>[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2})_" + Pattern.quote(this.world.getFileName()) + "( (?<count>[0-9]+))?\\.zip");
        this.refresh();
    }

    public void refresh() {
        this.setLoading(true);
        Task.supplyAsync(() -> {
            if (Files.isDirectory(this.backupsDir, new LinkOption[0])) {
                try (Stream<Path> paths = Files.list(this.backupsDir);){
                    ArrayList result = new ArrayList();
                    paths.forEach(path -> {
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            try {
                                Matcher matcher = this.backupFileNamePattern.matcher(path.getFileName().toString());
                                if (matcher.matches()) {
                                    LocalDateTime time = LocalDateTime.parse(matcher.group("datetime"), TIME_FORMATTER);
                                    int count = 0;
                                    if (matcher.group("count") != null) {
                                        count = Integer.parseInt(matcher.group("count"));
                                    }
                                    result.add(new BackupInfo((Path)path, new World((Path)path), time, count));
                                }
                            }
                            catch (Throwable e) {
                                Logger.LOG.warning("Failed to load backup file " + String.valueOf(path), e);
                            }
                        }
                    });
                    result.sort(Comparator.naturalOrder());
                    ArrayList arrayList = result;
                    return arrayList;
                }
            }
            return new ArrayList();
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            this.setLoading(false);
            if (exception == null) {
                this.setItems(FXCollections.observableList((List)result));
            } else {
                Logger.LOG.warning("Failed to load backups", exception);
            }
        }).start();
    }

    protected Skin<?> createDefaultSkin() {
        return new WorldBackupsPageSkin();
    }

    void createBackup() {
        Controllers.taskDialog(new WorldBackupTask(this.world, this.backupsDir, false).setName(I18n.i18n("world.backup.processing")).thenApplyAsync(path -> {
            Matcher matcher = this.backupFileNamePattern.matcher(path.getFileName().toString());
            if (!matcher.matches()) {
                throw new AssertionError((Object)("Wrong backup file name" + String.valueOf(path)));
            }
            LocalDateTime time = LocalDateTime.parse(matcher.group("datetime"), TIME_FORMATTER);
            int count = 0;
            if (matcher.group("count") != null) {
                count = Integer.parseInt(matcher.group("count"));
            }
            return Pair.pair(path, new BackupInfo((Path)path, new World((Path)path), time, count));
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.getItems().add((Object)((BackupInfo)result.getValue()));
                this.getItems().sort(Comparator.naturalOrder());
                Controllers.dialog(I18n.i18n("world.backup.create.success", result.getKey()), null, MessageDialogPane.MessageType.INFO);
            } else if (exception instanceof WorldLockedException) {
                Controllers.dialog(I18n.i18n("world.locked.failed"), null, MessageDialogPane.MessageType.WARNING);
            } else {
                Logger.LOG.warning("Failed to create backup", exception);
                Controllers.dialog(I18n.i18n("world.backup.create.failed", StringUtils.getStackTrace(exception)), null, MessageDialogPane.MessageType.WARNING);
            }
        }), I18n.i18n("world.backup"), null);
    }

    private final class WorldBackupsPageSkin
    extends ToolbarListPageSkin<WorldBackupsPage> {
        WorldBackupsPageSkin() {
            super(WorldBackupsPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(WorldBackupsPage skinnable) {
            JFXButton createBackup = WorldBackupsPageSkin.createToolbarButton2(I18n.i18n("world.backup.create.new_one"), SVG.ARCHIVE, skinnable::createBackup);
            createBackup.setDisable(WorldBackupsPage.this.isReadOnly);
            Node[] nodeArray = new Node[2];
            nodeArray[0] = WorldBackupsPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
            nodeArray[1] = createBackup;
            return Arrays.asList(nodeArray);
        }
    }

    public final class BackupInfo
    extends Control
    implements Comparable<BackupInfo> {
        private final Path file;
        private final World backupWorld;
        private final LocalDateTime backupTime;
        private final int count;

        public BackupInfo(Path file, World backupWorld, LocalDateTime backupTime, int count) {
            this.file = file;
            this.backupWorld = backupWorld;
            this.backupTime = backupTime;
            this.count = count;
        }

        public World getBackupWorld() {
            return this.backupWorld;
        }

        public LocalDateTime getBackupTime() {
            return this.backupTime;
        }

        protected Skin<?> createDefaultSkin() {
            return new BackupInfoSkin(this);
        }

        void onReveal() {
            FXUtils.showFileInExplorer(this.file);
        }

        void onDelete() {
            WorldBackupsPage.this.getItems().remove((Object)this);
            Task.runAsync(() -> Files.delete(this.file)).start();
        }

        @Override
        public int compareTo(@NotNull BackupInfo that) {
            int c = this.backupTime.compareTo(that.backupTime);
            return c != 0 ? c : Integer.compare(this.count, that.count);
        }
    }

    private static final class BackupInfoSkin
    extends SkinBase<BackupInfo> {
        BackupInfoSkin(BackupInfo skinnable) {
            super((Control)skinnable);
            World world = skinnable.getBackupWorld();
            BorderPane root = new BorderPane();
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            StackPane left = new StackPane();
            root.setLeft((Node)left);
            left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
            ImageView imageView = new ImageView();
            left.getChildren().add((Object)imageView);
            FXUtils.limitSize(imageView, 32.0, 32.0);
            imageView.setImage(world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : world.getIcon());
            TwoLineListItem item = new TwoLineListItem();
            root.setCenter((Node)item);
            if (skinnable.getBackupWorld().getWorldName() != null) {
                item.setTitle(StringUtils.parseColorEscapes(skinnable.getBackupWorld().getWorldName()));
            }
            item.setSubtitle(I18n.formatDateTime(skinnable.getBackupTime()) + (String)(skinnable.count == 0 ? "" : " (" + skinnable.count + ")"));
            if (world.getGameVersion() != null) {
                item.addTag(I18n.getDisplayVersion(world.getGameVersion()));
            }
            HBox right = new HBox(8.0);
            root.setRight((Node)right);
            right.setAlignment(Pos.CENTER_RIGHT);
            JFXButton btnReveal = new JFXButton();
            right.getChildren().add((Object)btnReveal);
            FXUtils.installFastTooltip((Node)btnReveal, I18n.i18n("reveal.in_file_manager"));
            btnReveal.getStyleClass().add((Object)"toggle-icon4");
            btnReveal.setGraphic(SVG.FOLDER_OPEN.createIcon());
            btnReveal.setOnAction(event -> skinnable.onReveal());
            JFXButton btnDelete = new JFXButton();
            right.getChildren().add((Object)btnDelete);
            FXUtils.installFastTooltip((Node)btnDelete, I18n.i18n("world.backup.delete"));
            btnDelete.getStyleClass().add((Object)"toggle-icon4");
            btnDelete.setGraphic(SVG.DELETE.createIcon());
            btnDelete.setOnAction(event -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), skinnable::onDelete, null));
            this.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)root)});
        }
    }
}

