//
// Created by fang on 2023/4/23.
//

#pragma once

#include <vector>
#include <map>
#include <string>
#include <borealis/views/dialog.hpp>
#include <borealis/core/thread.hpp>

#include "utils/config_helper.hpp"

using namespace brls::literals;

namespace wiliwili {

// 用户id、{ 时间、内容 }
typedef std::map<std::string, std::vector<std::string>> BanList;

/**
 * 永久禁止使用名单
 * 涉及到人身攻击、言语羞辱等内容，永久不欢迎这些用户
 */
static BanList banList = {
    {"173504381", {"2023-07-27 06:12", "发布评论：\"冒着ban机的风险在ns上搞手机上就能用的软件，多半脑子有问题\""}},
    {"334039311", {"2023-04-22 09:30:23", "在作者视频发送弹幕：\"破解机滚吧\""}},
    {"1386247250",
     {"2022-10-03 14:22:43", "在作者视频发送评论，言语恶劣，内容概括为：\"未经调查评论作者为炒二手游戏机的贩子\""}},
    {"38806518", {"2022-09-04 19:42:10", "在作者视频发送评论：\"搞破解的剑宗。就你这还要啥支持？\""}},
};

/**
 * 提醒名单
 * 名单内用户在进入应用时会弹出提醒
 * 注：针对特定平台的发言，仅在特定平台客户端提醒
 */

static BanList hintList = {
#ifdef __SWITCH__
    {"356118574", {"2023-08-14 08:18", "发布评论：\"意义在哪\""}},
    {"107121156",
     {"2023-08-01 01:19", "发布评论：\"这些都是没用的功能，拿来折腾娱乐的，装完了估计几个月都不会打开一次。\""}},
    {"457599240", {"2023-07-31 17:54", "发布评论：\"这样折腾感觉还不如直接整个手机。。\""}},
    {"383216385", {"2023-07-28 19:24", "发布评论：\"没用的功能\""}},
    {"8164546", {"2023-07-27 20:00", "发布评论：\"游戏机就用来玩游戏吧，搞这些，还不如用手机\""}},
    {"233873353", {"2023-07-27 07:17", "发布评论：\"花里胡哨的有啥用\""}},
    {"3514445", {"2023-06-28 09:11:05", "在作者视频发送弹幕：\"有2k不看，拿720p看，没事吧\""}},
    {"564824325", {"2023-05-29 07:41", "发布评论：\"看b站手机不更容易吗，ns看b站不脱裤子放屁？\""}},
    {"34359982",
     {"2023-05-28 17:20:09",
      "在作者视频发送评论：\"我还是不理解，为啥不把手机掏出来看，这年头手机都没720p的吧。。。 "
      "我也有switch，纯纯的健身环启动器\""}},
    {"604953196", {"2023-05-12 06:51:23", "在作者视频发送弹幕：\"720p有意思吗\""}},
    {"5728203",
     {"2023-05-02 14:56:43", "在作者视频发送弹幕：\"虽然有挺好 但是拿手上不如手机，接电视不如直接用电视。。\""}},
    {"43465933", {"2023-04-19 17:11:00", "在作者视频发送弹幕：\"ns画质这么低都有人拿来看片啊\""}},
    {"40993847", {"2023-04-16 22:04:02", "在作者视频发送弹幕：\"这鬼东西你送我 我都不要\""}},
    {"310762077", {"2023-04-01 14:26:09", "在作者视频发送弹幕：\"手机不更方便吗？\""}},
    {"1950252998", {"2023-02-12 23:28", "发布评论：\"难道真的有人看视频？不用平板，不用手机，用游戏机吗？\""}},
    {"12463483", {"2022-09-29 05:46:28", "在作者视频发送弹幕：\"本末倒置游戏机不用来玩游戏看视频那要手机干嘛\""}},
    {"28480830", {"2022-09-25 13:51:40", "在作者视频发送弹幕：\"用手机比这玩意儿好多了，完全没有用啊\""}},
    {"97191935",
     {"2022-09-24 13:44:15",
      "在作者视频发送评论：\"所以说这是必须大气层后才能用的东西，你正儿八经做好了挂到商店卖1块钱不香么\""}},
    {"32254678", {"2022-09-24 13:16:07", "在作者视频发送弹幕：\"现在人手一部手机，还需要用游戏机看视频？\""}},
    {"1480776",
     {"2022-09-07 11:28:01", "在作者视频发送弹幕：\"不是什么好人笑死我了，自己做这个东西是为了什么还想不清楚\""}},
    {"406458700", {"2022-09-04 11:35:51", "在作者视频发送弹幕：\"主要是up推广破解机\""}},
    {"325042091", {"2022-12-06 20:01", "在作者视频发送评论：\"ns上B站不好用，卸载了。\""}},
    {"390053198", {"2022-11-28 00:07", "在作者视频发送评论：\"虽然但是，用ns看b站就那烂屏幕还不如用手机呢\""}},
    {"27472245",
     {"2022-11-22 12:10",
      "在作者视频发送评论：\"大屏手机的年代，谁捧着这么重的东西看视频？还各种小毛病，连接电视机看吧，但既然都有电视机了"
      "……何必呢\""}},
    {"487951303", {"2022-11-21 11:39", "在作者视频发送评论：\"没搞懂意义在哪儿？\""}},
#else
    {"407694319", {"2023-07-31 17:45:48", "在作者视频发送评论：\"都不如uwp好用\""}},
    {"45425845", {"2023-07-31 16:59:25", "在作者视频发送评论：\"我的评价是，还是网页端好使[doge]\""}},
#endif
    {"9355679", {"2022-09-04 20:39:55", "在作者视频发送评论：\"wiliwili，这不是盗版是什么[辣眼睛]\""}},
};

static void checkBanList() {
    // 检查不欢迎名单
    std::string userid = ProgramConfig::instance().getUserID();
    if (wiliwili::banList.count(userid)) {
        brls::sync([userid]() {
            GA("ban", {{"user", userid},
                       {"version", APPVersion::instance().getVersionStr()},
                       {"git", APPVersion::instance().git_tag},
                       {"platform", APPVersion::instance().getPlatform()}})
            auto& data = wiliwili::banList[userid];
            auto dialog = new brls::Dialog(fmt::format("您于 {}\n{}\n现已被永久禁止使用本客户端", data[0], data[1]));
            dialog->setCancelable(false);
            dialog->addButton("hints/ok"_i18n, []() { brls::Application::quit(); });
            dialog->open();
        });
    } else if (wiliwili::hintList.count(userid)) {
        brls::sync([userid]() {
            GA("ban", {{"user", userid},
                       {"version", APPVersion::instance().getVersionStr()},
                       {"git", APPVersion::instance().git_tag},
                       {"platform", APPVersion::instance().getPlatform()}})
            auto& data  = wiliwili::hintList[userid];
            auto dialog = new brls::Dialog(fmt::format("特此提醒\n您于 {}\n{}\n", data[0], data[1]));
            dialog->addButton("hints/ok"_i18n, []() {});
            dialog->open();
        });
    }
}

};  // namespace wiliwili
