# 竖排引擎架构设计文档

本文档描述了 `luatex-cn` 中用于竖排排版的“三阶段流水线”架构及核心设计。

## 三阶段流水线 (Three-Stage Pipeline)

### 第一阶段：节点展平 (Stage 1: Flattening)
*   **核心模块**: `luatex-cn-vertical-flatten-nodes.lua`
*   **主要任务**: 将 TeX 传入的嵌套盒子（vbox/hbox）打碎，转换成一维的线性节点流。
*   **关键动作**: 在 TeX 盒子结构被解构前，提取缩进（Indent）等布局信息并转化为节点属性（Attribute）。

### 第二阶段：虚拟网格布局 (Stage 2: Layout)
*   **核心模块**: `luatex-cn-vertical-layout-grid.lua`
*   **主要任务**: 在不修改节点本身的情况下，计算每个节点在虚拟网格中的坐标（页、列、行）。
*   **核心逻辑**:
    *   **占用地图 (Occupancy Map)**: 追踪网格占用情况，防止正文与跳转文本框（Textbox）重叠。
    *   **避让逻辑**: 自动跳过版心列（Gutter）和悬浮块占用的位置。
    *   **文本流控**: 处理夹注（Jiazhu）的双行排列、段落首行缩进等复杂逻辑。
*   **输出**: 生成 `layout_map`（节点指针 -> 坐标位置的映射表）。

### 第三阶段：视觉渲染 (Stage 3: Rendering)
*   **核心模块**: `luatex-cn-vertical-render-page.lua`
*   **主要任务**: 根据布局地图，将坐标应用到节点，并绘制视觉装饰元素。
*   **关键动作**:
    *   **定位应用**: 为字形（Glyph）设置 `xoffset`/`yoffset`，为盒子（Box）插入 `kern`/`shift`。
    *   **视觉绘制**: 使用 PDF Literal 指令绘制边框、背景、版心装饰（如鱼尾）及页码。
    *   **物理转换**: 处理从左向右的 TLT 盒子到从右向左（RTL）竖排视觉的坐标转换。

---

## 常量与属性说明 (`luatex-cn-vertical-base-constants.lua`)

属性（Attribute）是 TeX 与 Lua、以及流水线各阶段之间沟通的“情报系统”。

| 常量名称 | 功能描述 | 使用阶段 |
| :--- | :--- | :--- |
| `ATTR_INDENT` / `RIGHT_INDENT` | 存储字符的左右缩进值（sp）。 | **阶段1** 提取；**阶段2** 决定行起始位置。 |
| `ATTR_TEXTBOX_WIDTH/HEIGHT` | 标记非标准盒子在网格中占用的行列数。 | **阶段2** 用于标记网格占用，防止重叠。 |
| `ATTR_BLOCK_ID` | 段落分组 ID，用于实现首行缩进等逻辑。 | **阶段2** 识别新段落的开始。 |
| `ATTR_JIAZHU` / `SUB` / `MODE` | 夹注（小字双行）的标记及排版模式。 | **阶段2** 触发特殊的双行流分配算法。 |
| `ATTR_DECORATE_ID` / `FONT` | 装饰符标记，如文字旁的红圈、着重号。 | **阶段3** 在对应文字位置叠加绘制装饰字符。 |
| `ATTR_CHAPTER_REG_ID` | 章节追踪 ID。 | **阶段2** 检测页面章节变化以更新版心。 |
| `SIDENOTE_USER_ID` | 侧批（批注）标记。 | **阶段2** 锁定锚点；**阶段3** 绘制在行间空隙。 |
| `JUDOU_USER_ID` | 句读（标点）标记。 | **阶段2/3** 控制标点在字角位置的精准定位。 |
| `BANXIN_USER_ID` | 版心锚点辅助标记。 | **阶段3** 作为绘制版心中央装饰元素的信号。 |

---

## 协作总结
1.  **第一阶段**负责从 TeX 环境中“抢救”逻辑结构信息。
2.  **第二阶段**在理想化的网格坐标系中应用排版规则。
3.  **第三阶段**负责将逻辑网格转化为物理坐标和 PDF 绘图命令。
