/*
 * Decompiled with CFR 0.152.
 */
package com.hbm;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.Inventory.recipe.CrackingRecipes;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.capabilities.network.TransmitterNetworkRegistry;
import com.hbm.compat.ballistix.BallistixCompat;
import com.hbm.compat.bigexplosives.BigExplosivesMod;
import com.hbm.config.ClientConfig;
import com.hbm.config.CommonConfig;
import com.hbm.config.ServerConfig;
import com.hbm.datagen.AdvacementGen;
import com.hbm.datagen.HBMJsonProvider;
import com.hbm.datagen.LanguageProvider;
import com.hbm.datagen.WorldGen;
import com.hbm.datagen.damageSource.HBMDamageTagProvider;
import com.hbm.datagen.loot.BlockLootGen;
import com.hbm.datagen.loot.ChestLootGen;
import com.hbm.datagen.loot.EntityLootGen;
import com.hbm.datagen.loot.FishLootGen;
import com.hbm.datagen.model.BlockStateGen;
import com.hbm.datagen.model.ItemModelGen;
import com.hbm.datagen.recipe.RecipeGen;
import com.hbm.datagen.tag.BlockTagsGen;
import com.hbm.datagen.tag.ItemTagsGen;
import com.hbm.dev.AssetConsistencyChecker;
import com.hbm.dev.ModelValidator;
import com.hbm.effect.ModEffects;
import com.hbm.entity.ModEntityType;
import com.hbm.gui.ModMenuType;
import com.hbm.item.HBMItems;
import com.hbm.main.ClientEventHanler;
import com.hbm.main.ServerEventHandler;
import com.hbm.network.ModMessages;
import com.hbm.particle.ModParticleTypes;
import com.hbm.reactor.pile.PileNeutronTicker;
import com.hbm.reactor.rbmk.RBMKManager;
import com.hbm.registries.ModBlocks;
import com.hbm.registries.ModCreativeModeTab;
import com.hbm.registries.ModKeyMapping;
import com.hbm.registries.ModSounds;
import com.hbm.render.model.Models;
import com.hbm.world.feature.ModFeatures;
import com.hbm.world.structure.ModStructureProcessors;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="hbm")
public class HBM {
    public static final String MODID = "hbm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean debug = false;
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("hbmConfigs");
    public static final Path RECIPE_PATH = FMLPaths.CONFIGDIR.get().resolve("hbmRecipes");

    public HBM() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onPostLoad);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(ModCreativeModeTab::addCreative);
        modEventBus.addListener(ModKeyMapping::register);
        ClientEventHanler.registerEvents(MinecraftForge.EVENT_BUS, modEventBus);
        ServerEventHandler.registerEvents(MinecraftForge.EVENT_BUS, modEventBus);
        ModEntityType.ENTITY_TYPES.register(modEventBus);
        HBMItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeModeTab.CREATIVE_MODE_TABS.register(modEventBus);
        ModBlockEntityType.REGISTER.register(modEventBus);
        ModRecipes.RECIPE_TYPE.register(modEventBus);
        ModRecipes.SERIALIZER.register(modEventBus);
        ModFluids.register(modEventBus);
        ModParticleTypes.PARTICLE_TYPES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModFeatures.register(modEventBus);
        ModStructureProcessors.STRUCTURE_PROCESSORS.register(modEventBus);
        ModMenuType.MOD_MENU_TYPES.register(modEventBus);
        ModEffects.register(modEventBus);
        BigExplosivesMod.register(modEventBus);
        BallistixCompat.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.CONFIG_SPEC, "hbm-common.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (!CONFIG_PATH.toFile().exists()) {
            CONFIG_PATH.toFile().mkdir();
        }
        ModMessages.register();
        TransmitterNetworkRegistry.initiate();
        RBMKManager.init();
        PileNeutronTicker.init();
        CrackingRecipes.registerDefaults();
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        Models.onClientSetup(event);
    }

    public void onPostLoad(FMLLoadCompleteEvent event) {
        ClientConfig.initConfig();
        ServerConfig.initConfig();
        event.enqueueWork(() -> {
            AssetConsistencyChecker.runIfRequested();
            ModelValidator.runIfRequested();
        });
    }

    private void onServerStopped(ServerStoppedEvent event) {
        TransmitterNetworkRegistry.reset();
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new HBMJsonProvider(packOutput, MODID, helper, false));
        generator.addProvider(event.includeServer(), (DataProvider)new HBMDamageTagProvider(packOutput, lookupProvider, MODID, helper));
        BlockTagsGen blockTagsGen = new BlockTagsGen(packOutput, lookupProvider, MODID, helper);
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, helper, List.of(new AdvacementGen())));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(packOutput, helper, MODID));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsGen);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGen(packOutput, lookupProvider, blockTagsGen.m_274426_(), MODID, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new WorldGen(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), output -> new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootGen::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(ChestLootGen::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(FishLootGen::new, LootContextParamSets.f_81414_), new LootTableProvider.SubProviderEntry(EntityLootGen::new, LootContextParamSets.f_81415_))));
        boolean includeClient = event.includeClient();
        LOGGER.info("GatherData flags -> includeServer: {}, includeClient: {}", (Object)event.includeServer(), (Object)includeClient);
        if (!includeClient) {
            LOGGER.warn("runData invoked without --client flag; forcing client-side datagen to keep assets in sync.");
        }
        DataGenerator.PackGenerator resourcePack = generator.m_253147_(true);
        resourcePack.m_253108_(output -> new HBMJsonProvider(output, MODID, helper, true));
        resourcePack.m_253108_(output -> new LanguageProvider(output, MODID, "en_us"));
        resourcePack.m_253108_(output -> new ItemModelGen(output, MODID, helper));
        resourcePack.m_253108_(output -> new BlockStateGen(output, MODID, helper));
        LOGGER.info("Datagen providers registered: {}", generator.getProvidersView().keySet());
    }

    public static boolean isLoad(String modID) {
        return ModList.get().isLoaded(modID);
    }

    public static ResourceLocation rl(String s) {
        return ResourceLocation.m_214293_((String)MODID, (String)s);
    }

    public static ResourceLocation modelRl(String s) {
        return HBM.rl("models/" + s);
    }
}

