/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.HBM;
import com.hbm.Inventory.fluid.trait.FluidTrait;
import com.hbm.Inventory.fluid.trait.FluidTraitSimple;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ExtendedFluidType
extends FluidType {
    public String name;
    public ExtendedProperties hbmProperties;
    public ForgeFlowingFluid.Properties flowProperties;
    public final ResourceLocation stillTexture;
    public final ResourceLocation flowingTexture;
    public final ResourceLocation overlayTexture;
    public final ResourceLocation guiTexture = GUI_CUSTOM_WATER;
    public final int tintColor;
    public final Vector3f fogColor;
    public static final ResourceLocation WATER_STILL_TEX = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOWING_TEX = new ResourceLocation("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_still");
    public static final ResourceLocation GUI_WATER = HBM.rl("textures/gui/fluids/water.png");
    public static final ResourceLocation GUI_LAVA = HBM.rl("textures/gui/fluids/lava.png");
    public static final ResourceLocation GUI_MILK = HBM.rl("textures/gui/fluids/milk.png");
    public static final ResourceLocation GUI_CUSTOM_WATER = HBM.rl("textures/gui/fluids/custom_water.png");
    public static final ResourceLocation GUI_CUSTOM_OIL = HBM.rl("textures/gui/fluids/custom_oil.png");
    public static final ResourceLocation GUI_CUSTOM_TOXIN = HBM.rl("textures/gui/fluids/custom_toxin.png");
    public static final ResourceLocation GUI_CUSTOM_LAVA = HBM.rl("textures/gui/fluids/custom_lava.png");
    public static final FluidType.Properties prop_air = FluidType.Properties.create().motionScale(1.0).canPushEntity(false).canSwim(false).canDrown(false).fallDistanceModifier(1.0f).pathType(null).adjacentPathType(null).density(0).temperature(0).viscosity(0);
    public static final FluidType.Properties prop_lava = FluidType.Properties.create().canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(15).density(3000).viscosity(6000).temperature(1300);
    public static final FluidType.Properties prop_water = FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true);
    public static final FluidType.Properties solution = prop_water.canConvertToSource(false);
    public static final FluidTraitSimple.FT_Liquid LIQUID = new FluidTraitSimple.FT_Liquid();
    public static final FluidTraitSimple.FT_Viscous VISCOUS = new FluidTraitSimple.FT_Viscous();
    public static final FluidTraitSimple.FT_Gaseous_ART EVAP = new FluidTraitSimple.FT_Gaseous_ART();
    public static final FluidTraitSimple.FT_Gaseous GASEOUS = new FluidTraitSimple.FT_Gaseous();
    public static final FluidTraitSimple.FT_Plasma PLASMA = new FluidTraitSimple.FT_Plasma();
    public static final FluidTraitSimple.FT_Amat ANTI = new FluidTraitSimple.FT_Amat();
    public static final FluidTraitSimple.FT_LeadContainer LEADCON = new FluidTraitSimple.FT_LeadContainer();
    public static final FluidTraitSimple.FT_NoContainer NOCON = new FluidTraitSimple.FT_NoContainer();
    public static final FluidTraitSimple.FT_NoID NOID = new FluidTraitSimple.FT_NoID();
    public static final FluidTraitSimple.FT_Delicious DELICIOUS = new FluidTraitSimple.FT_Delicious();
    public static final FluidTraitSimple.FT_Unsiphonable UNSIPHONABLE = new FluidTraitSimple.FT_Unsiphonable();

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public ResourceLocation getGUITexture() {
        return this.guiTexture;
    }

    public Vector3f getFogColor() {
        return this.fogColor;
    }

    public ExtendedFluidType(String name, int color, FluidType.Properties properties, ExtendedProperties properties2) {
        this(name, WATER_STILL_TEX, WATER_FLOWING_TEX, WATER_OVERLAY, color, new Vector3f((float)(color % 256), (float)(color / 256 % 256), (float)(color / 65536 % 256)), properties, properties2);
    }

    public ExtendedFluidType(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture, int tintColor, Vector3f fogColor, FluidType.Properties properties, ExtendedProperties properties2) {
        super(properties.descriptionId("block.hbm." + name));
        this.name = name;
        this.hbmProperties = properties2;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.overlayTexture = overlayTexture;
        this.tintColor = tintColor;
        this.fogColor = fogColor;
    }

    public <T extends FluidTrait> T getTrait(Class<? extends T> trait) {
        return (T)this.hbmProperties.traits.get(trait);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ExtendedFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return ExtendedFluidType.this.flowingTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return ExtendedFluidType.this.overlayTexture;
            }

            public int getTintColor() {
                return ExtendedFluidType.this.tintColor;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return ExtendedFluidType.this.fogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)1.0f);
                RenderSystem.setShaderFogEnd((float)6.0f);
            }
        });
    }

    public static FluidType getFTFromJson(JsonObject json, String key) {
        return (FluidType)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getValue(new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)key)));
    }

    public static class ExtendedProperties {
        public int poison = 0;
        public int flammability = 0;
        public int reactivity = 0;
        public HashMap<Class<? extends FluidTrait>, FluidTrait> traits = new HashMap();

        public static ExtendedProperties of() {
            return new ExtendedProperties();
        }

        public ExtendedProperties pfr(int p, int f, int r) {
            this.poison = p;
            this.flammability = f;
            this.reactivity = r;
            return this;
        }

        public ExtendedProperties traits(FluidTrait ... traits) {
            for (FluidTrait trait : traits) {
                this.traits.put(trait.getClass(), trait);
            }
            return this;
        }
    }

    public static class PropertiesHolder
    extends ForgeFlowingFluid.Properties {
        public FluidType fluidType;
        public Fluid still;
        public Fluid flowing;
        public Item bucket;
        public LiquidBlock block;

        public PropertiesHolder(FluidType fluidType, Fluid still, Fluid flowing) {
            super(() -> fluidType, () -> still, () -> flowing);
        }
    }

    public static enum FuelGrade {
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High"),
        AERO("Aviation"),
        GAS("Gaseous");

        private String grade;

        private FuelGrade(String grade) {
            this.grade = grade;
        }

        public String getGrade() {
            return this.grade;
        }
    }
}

