/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid;

import com.hbm.HBM;
import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.trait.FT_Coolable;
import com.hbm.Inventory.fluid.trait.FT_Corrosive;
import com.hbm.Inventory.fluid.trait.FT_Heatable;
import com.hbm.item.tool.FluidBucketItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"hbm");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"hbm");
    public static final DeferredRegister<Block> FLUID_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"hbm");
    public static final DeferredRegister<Item> FLUID_CONTAINER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hbm");
    public static final List<FluidRegistryHolder> fluidList = new ArrayList<FluidRegistryHolder>();
    public static final ExtendedFluidType water = new ExtendedFluidType("water", 0x3333FF, ExtendedFluidType.prop_water, ExtendedFluidType.ExtendedProperties.of().pfr(0, 0, 0));
    public static final ExtendedFluidType lava = new ExtendedFluidType("lava", 0xFF3300, ExtendedFluidType.prop_lava, ExtendedFluidType.ExtendedProperties.of().pfr(4, 0, 0));
    public static final ExtendedFluidType milk = new ExtendedFluidType("milk", 0xA0A0A4, ExtendedFluidType.prop_water.canConvertToSource(false), ExtendedFluidType.ExtendedProperties.of().pfr(0, 0, 0));
    public static final ExtendedFluidType irradiated_water = new ExtendedFluidType("irradiated_water", HBM.rl("block/fluid/irradiated_water_still"), HBM.rl("block/fluid/irradiated_water_flow"), ExtendedFluidType.WATER_OVERLAY, -1579140912, new Vector3f(0.8784314f, 0.21960784f, 0.8156863f), ExtendedFluidType.prop_water.descriptionId("Radioactive Water"), ExtendedFluidType.ExtendedProperties.of());
    public static final ExtendedFluidType irradiated_polluted = new ExtendedFluidType("irradiated_polluted", HBM.rl("block/fluid/irradiated_polluted_still"), HBM.rl("block/fluid/irradiated_polluted_flow"), ExtendedFluidType.WATER_OVERLAY, -1579140912, new Vector3f(0.8784314f, 0.21960784f, 0.8156863f), ExtendedFluidType.prop_water.descriptionId("Nuclear-contaminated Water"), ExtendedFluidType.ExtendedProperties.of());
    public static final ExtendedFluidType sulfuric_acid = new ExtendedFluidType("sulfuric_acid", 11577956, ExtendedFluidType.solution.descriptionId("Sulfuric Acid"), ExtendedFluidType.ExtendedProperties.of().pfr(3, 0, 2).traits(new FT_Corrosive(50), ExtendedFluidType.LIQUID));
    public static final ExtendedFluidType steam = new ExtendedFluidType("steam", 0xE5E5E5, ExtendedFluidType.solution.temperature(373), ExtendedFluidType.ExtendedProperties.of().pfr(3, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static final ExtendedFluidType HOTSTEAM = new ExtendedFluidType("hot_steam", 15193814, ExtendedFluidType.solution.temperature(573), ExtendedFluidType.ExtendedProperties.of().pfr(4, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static final ExtendedFluidType SUPERHOTSTEAM = new ExtendedFluidType("superhot_steam", 0xE7B7B7, ExtendedFluidType.solution.temperature(723), ExtendedFluidType.ExtendedProperties.of().pfr(4, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static final ExtendedFluidType ULTRAHOTSTEAM = new ExtendedFluidType("ultrahot_steam", 0xE39393, ExtendedFluidType.solution.temperature(873), ExtendedFluidType.ExtendedProperties.of().pfr(4, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static final ExtendedFluidType carbon_dioxide = new ExtendedFluidType("carbon_dioxide", 0xB0B0B0, ExtendedFluidType.solution.descriptionId("Carbon Dioxide"), ExtendedFluidType.ExtendedProperties.of().pfr(0, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static final ExtendedFluidType coolant_hot = new ExtendedFluidType("coolant_hot", 10048094, ExtendedFluidType.solution, ExtendedFluidType.ExtendedProperties.of().pfr(1, 0, 0).traits(ExtendedFluidType.LIQUID));
    public static final ExtendedFluidType coolant = new ExtendedFluidType("coolant", 14220543, ExtendedFluidType.solution, ExtendedFluidType.ExtendedProperties.of().pfr(1, 0, 0).traits(ExtendedFluidType.LIQUID));
    public static final ExtendedFluidType hydrogen = new ExtendedFluidType("hydrogen", 4359924, ExtendedFluidType.solution.descriptionId("Hydrogen"), ExtendedFluidType.ExtendedProperties.of().pfr(3, 4, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType deuterium = new ExtendedFluidType("deuterium", 3107839, ExtendedFluidType.solution.descriptionId("Deuterium"), ExtendedFluidType.ExtendedProperties.of().pfr(3, 4, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType tritium = new ExtendedFluidType("tritium", 731782, ExtendedFluidType.solution.descriptionId("Tritium"), ExtendedFluidType.ExtendedProperties.of().pfr(3, 4, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType helium3 = new ExtendedFluidType("helium3", 16773316, ExtendedFluidType.solution.descriptionId("Helium-3"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 2, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType helium4 = new ExtendedFluidType("helium4", 16757888, ExtendedFluidType.solution.descriptionId("Helium-4"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 2, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType oxygen = new ExtendedFluidType("oxygen", 11854591, ExtendedFluidType.solution.descriptionId("Oxygen"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 1, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType chlorine = new ExtendedFluidType("chlorine", 14345624, ExtendedFluidType.solution.descriptionId("Chlorine"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 1, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType diesel = new ExtendedFluidType("diesel", 15920853, ExtendedFluidType.solution.descriptionId("Diesel"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0));
    public static final ExtendedFluidType oil = new ExtendedFluidType("oil", 1905933, ExtendedFluidType.solution.descriptionId("Crude Oil"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0).traits(ExtendedFluidType.LIQUID, ExtendedFluidType.VISCOUS));
    public static final ExtendedFluidType crack_oil = new ExtendedFluidType("crack_oil", 2824720, ExtendedFluidType.solution.descriptionId("Cracked Oil"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 3, 0).traits(ExtendedFluidType.LIQUID, ExtendedFluidType.VISCOUS));
    public static final ExtendedFluidType bitumen = new ExtendedFluidType("bitumen", 1380107, ExtendedFluidType.solution.descriptionId("Bitumen"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 3, 0).traits(ExtendedFluidType.LIQUID, ExtendedFluidType.VISCOUS));
    public static final ExtendedFluidType smear = new ExtendedFluidType("smear", 4203027, ExtendedFluidType.solution.descriptionId("Heavy Residue"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0).traits(ExtendedFluidType.LIQUID, ExtendedFluidType.VISCOUS));
    public static final ExtendedFluidType naphtha = new ExtendedFluidType("naphtha", 16773557, ExtendedFluidType.solution.descriptionId("Naphtha"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 0));
    public static final ExtendedFluidType petroleum = new ExtendedFluidType("petroleum", 0x2E2E2E, ExtendedFluidType.solution.descriptionId("Petroleum"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 3, 0));
    public static final ExtendedFluidType aromatics = new ExtendedFluidType("aromatics", 11553678, ExtendedFluidType.solution.descriptionId("Aromatics"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 2, 1));
    public static final ExtendedFluidType unsaturateds = new ExtendedFluidType("unsaturateds", 16757575, ExtendedFluidType.solution.descriptionId("Unsaturateds"), ExtendedFluidType.ExtendedProperties.of().pfr(2, 1, 1));
    public static final ExtendedFluidType refinery_gas = new ExtendedFluidType("refinery_gas", 16767334, ExtendedFluidType.solution.descriptionId("Refinery Gas"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType diesel_crack = new ExtendedFluidType("diesel_crack", 15062187, ExtendedFluidType.solution.descriptionId("Cracked Diesel"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0));
    public static final ExtendedFluidType kerosene = new ExtendedFluidType("kerosene", 16184025, ExtendedFluidType.solution.descriptionId("Kerosene"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 0));
    public static final ExtendedFluidType wood_oil = new ExtendedFluidType("wood_oil", 3089689, ExtendedFluidType.solution.descriptionId("Wood Oil"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 0).traits(ExtendedFluidType.LIQUID, ExtendedFluidType.VISCOUS));
    public static final ExtendedFluidType heating_oil = new ExtendedFluidType("heating_oil", 9202475, ExtendedFluidType.solution.descriptionId("Heating Oil"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0));
    public static final ExtendedFluidType heating_oil_vacuum = new ExtendedFluidType("heating_oil_vacuum", 10713394, ExtendedFluidType.solution.descriptionId("Vacuum Heating Oil"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 2, 0));
    public static final ExtendedFluidType reform_gas = new ExtendedFluidType("reform_gas", 16576161, ExtendedFluidType.solution.descriptionId("Reform Gas"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 1).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType reformate = new ExtendedFluidType("reformate", 14734146, ExtendedFluidType.solution.descriptionId("Reformate"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 0));
    public static final ExtendedFluidType biogas = new ExtendedFluidType("biogas", 8312465, ExtendedFluidType.solution.descriptionId("Biogas"), ExtendedFluidType.ExtendedProperties.of().pfr(1, 1, 0).traits(ExtendedFluidType.GASEOUS));
    public static final ExtendedFluidType spent_steam = new ExtendedFluidType("spent_steam", 0xC9C9C9, ExtendedFluidType.solution.descriptionId("Spent Steam"), ExtendedFluidType.ExtendedProperties.of().pfr(0, 0, 0).traits(ExtendedFluidType.GASEOUS, ExtendedFluidType.UNSIPHONABLE));
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> COOLANT_HOT;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> COOLANT;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HYDROGEN;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> DEUTERIUM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> TRITIUM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HELIUM3;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HELIUM4;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> OXYGEN;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> CHLORINE;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> IRRADIATED_WATER;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> IRRADIATED_POLLUTED;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> SULFURIC_ACID;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> STEAM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HOT_STEAM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> SUPERHOT_STEAM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> CARBON_DIOXIDE;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> DIESEL;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> OIL;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> CRACK_OIL;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> BITUMEN;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> SMEAR;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> NAPHTHA;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> PETROLEUM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> AROMATICS;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> UNSATURATEDS;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> REFINERY_GAS;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> DIESEL_CRACK;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> KEROSENE;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> WOOD_OIL;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HEATING_OIL;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> HEATING_OIL_VACUUM;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> REFORM_GAS;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> REFORMATE;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> BIOGAS;
    public static FluidRegistryHolder<ExtendedFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> SPENT_STEAM;

    public static FluidRegistryHolder register(ExtendedFluidType fluidType) {
        String name = fluidType.name;
        RegistryObject type = FLUID_TYPES.register(name, () -> fluidType);
        RegistryObject source = FLUIDS.register(name, () -> new ForgeFlowingFluid.Source(fluidType.flowProperties));
        RegistryObject flowing = FLUIDS.register(name + "_flow", () -> new ForgeFlowingFluid.Flowing(fluidType.flowProperties));
        fluidType.flowProperties = new ForgeFlowingFluid.Properties((Supplier)type, (Supplier)source, (Supplier)flowing);
        RegistryObject block = FLUID_BLOCKS.register(name, () -> new LiquidBlock((Supplier)source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
        RegistryObject bucket = FLUID_CONTAINER.register("bucket_" + name, () -> new FluidBucketItem((Supplier<? extends Fluid>)source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        fluidType.flowProperties.block((Supplier)block);
        fluidType.flowProperties.bucket((Supplier)bucket);
        FluidRegistryHolder registryHolder = new FluidRegistryHolder(type, source, flowing, block, bucket);
        fluidList.add(registryHolder);
        return registryHolder;
    }

    public static void register(IEventBus modEventBus) {
        FLUIDS.register(modEventBus);
        FLUID_TYPES.register(modEventBus);
        FLUID_BLOCKS.register(modEventBus);
        FLUID_CONTAINER.register(modEventBus);
    }

    public static void bucketModel(ItemModelProvider provider) {
        fluidList.stream().map(FluidRegistryHolder::bucket).filter(bucket -> bucket.get() instanceof FluidBucketItem).forEach(bucket -> provider.withExistingParent(bucket.getId().m_135815_(), HBM.rl("item/fluid_bucket")));
    }

    public static void localName(LanguageProvider languageProvider) {
        fluidList.forEach(holder -> {
            ExtendedFluidType fluidType = (ExtendedFluidType)((Object)((Object)holder.type.get()));
            String enName = Arrays.stream(fluidType.name.split("_")).map(s -> s == null || s.isEmpty() ? s : s.substring(0, 1).toUpperCase() + s.substring(1)).reduce("", (ss, s) -> ss + " " + s);
            languageProvider.add(fluidType.getDescriptionId(), enName);
            Object patt19296$temp = holder.bucket().get();
            if (patt19296$temp instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)patt19296$temp;
                languageProvider.add((Item)bucketItem, enName + " Bucket");
            }
        });
    }

    static {
        FT_Heatable coolantHeatable = new FT_Heatable().setEff(FT_Heatable.HeatingType.HEATEXCHANGER, 1.0).setEff(FT_Heatable.HeatingType.PWR, 1.0).setEff(FT_Heatable.HeatingType.ICF, 1.0).addStep(300, 1, coolant_hot, 1);
        ModFluids.coolant.hbmProperties.traits.put(FT_Heatable.class, coolantHeatable);
        ModFluids.coolant_hot.hbmProperties.traits.put(FT_Coolable.class, new FT_Coolable(coolant, 1, 1, 300).setEff(FT_Coolable.CoolingType.HEATEXCHANGER, 1.0));
        COOLANT_HOT = ModFluids.register(coolant_hot);
        COOLANT = ModFluids.register(coolant);
        HYDROGEN = ModFluids.register(hydrogen);
        DEUTERIUM = ModFluids.register(deuterium);
        TRITIUM = ModFluids.register(tritium);
        HELIUM3 = ModFluids.register(helium3);
        HELIUM4 = ModFluids.register(helium4);
        OXYGEN = ModFluids.register(oxygen);
        CHLORINE = ModFluids.register(chlorine);
        IRRADIATED_WATER = ModFluids.register(irradiated_water);
        IRRADIATED_POLLUTED = ModFluids.register(irradiated_polluted);
        SULFURIC_ACID = ModFluids.register(sulfuric_acid);
        STEAM = ModFluids.register(steam);
        HOT_STEAM = ModFluids.register(HOTSTEAM);
        SUPERHOT_STEAM = ModFluids.register(SUPERHOTSTEAM);
        CARBON_DIOXIDE = ModFluids.register(carbon_dioxide);
        DIESEL = ModFluids.register(diesel);
        OIL = ModFluids.register(oil);
        CRACK_OIL = ModFluids.register(crack_oil);
        BITUMEN = ModFluids.register(bitumen);
        SMEAR = ModFluids.register(smear);
        NAPHTHA = ModFluids.register(naphtha);
        PETROLEUM = ModFluids.register(petroleum);
        AROMATICS = ModFluids.register(aromatics);
        UNSATURATEDS = ModFluids.register(unsaturateds);
        REFINERY_GAS = ModFluids.register(refinery_gas);
        DIESEL_CRACK = ModFluids.register(diesel_crack);
        KEROSENE = ModFluids.register(kerosene);
        WOOD_OIL = ModFluids.register(wood_oil);
        HEATING_OIL = ModFluids.register(heating_oil);
        HEATING_OIL_VACUUM = ModFluids.register(heating_oil_vacuum);
        REFORM_GAS = ModFluids.register(reform_gas);
        REFORMATE = ModFluids.register(reformate);
        BIOGAS = ModFluids.register(biogas);
        SPENT_STEAM = ModFluids.register(spent_steam);
    }

    public record FluidRegistryHolder<TYPE extends FluidType, SOURCE extends ForgeFlowingFluid.Source, FLOWING extends ForgeFlowingFluid.Flowing, BLOCK extends LiquidBlock, BUCKET extends BucketItem>(RegistryObject<TYPE> type, RegistryObject<SOURCE> source, RegistryObject<FLOWING> flowing, RegistryObject<BLOCK> block, RegistryObject<BUCKET> bucket) {
    }
}

