/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.trait.FluidTrait;
import com.hbm.utils.BobMth;
import java.io.IOException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class FT_Combustible
extends FluidTrait {
    protected FuelGrade fuelGrade;
    protected long combustionEnergy;

    public FT_Combustible() {
    }

    public FT_Combustible(FuelGrade grade, long energy) {
        this.fuelGrade = grade;
        this.combustionEnergy = energy;
    }

    @Override
    public void addInfo(List<Component> info) {
        super.addInfo(info);
        info.add((Component)Component.m_237115_((String)HBMLang.FT_COMBUSTIBLE1.key()).m_130940_(ChatFormatting.GOLD));
        info.add((Component)Component.m_237110_((String)HBMLang.FT_COMBUSTIBLE2.key(), (Object[])new Object[]{BobMth.getShortNumber(this.combustionEnergy)}).m_130940_(ChatFormatting.GOLD));
        info.add((Component)Component.m_237110_((String)HBMLang.FT_COMBUSTIBLE3.key(), (Object[])new Object[]{this.fuelGrade.getGrade()}).m_130940_(ChatFormatting.GOLD));
    }

    public long getCombustionEnergy() {
        return this.combustionEnergy;
    }

    public FuelGrade getGrade() {
        return this.fuelGrade;
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("energy").value(this.combustionEnergy);
        writer.name("grade").value(this.fuelGrade.name());
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        this.combustionEnergy = obj.get("energy").getAsLong();
        this.fuelGrade = FuelGrade.valueOf(obj.get("grade").getAsString());
    }

    public static enum FuelGrade {
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High"),
        AERO("Aviation"),
        GAS("Gaseous");

        private String grade;

        private FuelGrade(String grade) {
            this.grade = grade;
        }

        public String getGrade() {
            return this.grade;
        }
    }
}

