/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.trait.FluidTrait;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidType;

public class FT_Coolable
extends FluidTrait {
    protected HashMap<CoolingType, Double> efficiency = new HashMap();
    public FluidType coolsTo;
    public int amountReq;
    public int amountProduced;
    public int heatEnergy;

    public FT_Coolable() {
    }

    public FT_Coolable(FluidType type, int req, int prod, int heat) {
        this.coolsTo = type;
        this.amountReq = req;
        this.amountProduced = prod;
        this.heatEnergy = heat;
    }

    public FT_Coolable setEff(CoolingType type, double eff) {
        this.efficiency.put(type, eff);
        return this;
    }

    public double getEfficiency(CoolingType type) {
        Double eff = this.efficiency.get((Object)type);
        return eff != null ? eff : 0.0;
    }

    @Override
    public void addInfoHidden(List<Component> info) {
        info.add((Component)Component.m_237110_((String)HBMLang.FT_THERMAL_CAPACITY.key(), (Object[])new Object[]{this.heatEnergy, this.amountReq}).m_130940_(ChatFormatting.RED));
        for (CoolingType type : CoolingType.values()) {
            double eff = this.getEfficiency(type);
            if (!(eff > 0.0)) continue;
            info.add((Component)Component.m_237110_((String)HBMLang.FT_EFFICIENCY.key(), (Object[])new Object[]{type.name, (int)(eff * 100.0)}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("coolsTo").value(this.coolsTo.getDescriptionId());
        writer.name("amountReq").value((long)this.amountReq);
        writer.name("amountProd").value((long)this.amountProduced);
        writer.name("heatEnergy").value((long)this.heatEnergy);
        for (Map.Entry<CoolingType, Double> entry : this.efficiency.entrySet()) {
            writer.name(entry.getKey().name()).value((Number)entry.getValue());
        }
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        this.coolsTo = ExtendedFluidType.getFTFromJson(obj, "coolsTo");
        this.amountReq = obj.get("amountReq").getAsInt();
        this.amountProduced = obj.get("amountProd").getAsInt();
        this.heatEnergy = obj.get("heatEnergy").getAsInt();
        for (CoolingType type : CoolingType.values()) {
            if (!obj.has(type.name())) continue;
            this.efficiency.put(type, obj.get(type.name()).getAsDouble());
        }
    }

    public static enum CoolingType {
        TURBINE("Turbine Steam"),
        HEATEXCHANGER("Coolable");

        public String name;

        private CoolingType(String name) {
            this.name = name;
        }
    }
}

