/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.trait.FluidTrait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidType;

public class FT_Heatable
extends FluidTrait {
    protected List<HeatingStep> steps = new ArrayList<HeatingStep>();
    protected HashMap<HeatingType, Double> efficiency = new HashMap();

    public FT_Heatable addStep(int heat, int req, FluidType type, int prod) {
        this.steps.add(new HeatingStep(req, heat, type, prod));
        return this;
    }

    public FT_Heatable setEff(HeatingType type, double eff) {
        this.efficiency.put(type, eff);
        return this;
    }

    public double getEfficiency(HeatingType type) {
        Double eff = this.efficiency.get((Object)type);
        return eff != null ? eff : 0.0;
    }

    public HeatingStep getFirstStep() {
        return this.steps.get(0);
    }

    @Override
    public void addInfoHidden(List<Component> info) {
        info.add((Component)Component.m_237110_((String)HBMLang.FT_THERMAL_CAPACITY.key(), (Object[])new Object[]{this.getFirstStep().heatReq, this.getFirstStep().amountReq}).m_130940_(ChatFormatting.RED));
        for (HeatingType type : HeatingType.values()) {
            double eff = this.getEfficiency(type);
            if (!(eff > 0.0)) continue;
            info.add((Component)Component.m_237110_((String)HBMLang.FT_EFFICIENCY.key(), (Object[])new Object[]{type.name, (int)(eff * 100.0)}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("steps").beginArray();
        for (HeatingStep heatingStep : this.steps) {
            writer.beginObject();
            writer.name("typeProduced").value(heatingStep.typeProduced.getDescriptionId());
            writer.name("amountReq").value((long)heatingStep.amountReq);
            writer.name("amountProd").value((long)heatingStep.amountProduced);
            writer.name("heatReq").value((long)heatingStep.heatReq);
            writer.endObject();
        }
        writer.endArray();
        for (Map.Entry entry : this.efficiency.entrySet()) {
            writer.name(((HeatingType)((Object)entry.getKey())).name()).value((Number)entry.getValue());
        }
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        JsonArray steps = obj.get("steps").getAsJsonArray();
        for (int i = 0; i < steps.size(); ++i) {
            JsonObject step = steps.get(i).getAsJsonObject();
            this.steps.add(new HeatingStep(step.get("amountReq").getAsInt(), step.get("heatReq").getAsInt(), ExtendedFluidType.getFTFromJson(step, "typeProduced"), step.get("amountProd").getAsInt()));
        }
        for (HeatingType type : HeatingType.values()) {
            if (!obj.has(type.name())) continue;
            this.efficiency.put(type, obj.get(type.name()).getAsDouble());
        }
    }

    public static class HeatingStep {
        public final int amountReq;
        public final int heatReq;
        public final FluidType typeProduced;
        public final int amountProduced;

        public HeatingStep(int req, int heat, FluidType type, int prod) {
            this.amountReq = req;
            this.heatReq = heat;
            this.typeProduced = type;
            this.amountProduced = prod;
        }
    }

    public static enum HeatingType {
        BOILER("Boilable"),
        HEATEXCHANGER("Heatable"),
        PWR("PWR Coolant"),
        ICF("ICF Coolant"),
        PA("Particle Accelerator Coolant");

        public String name;

        private HeatingType(String name) {
            this.name = name;
        }
    }
}

