/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.trait.FluidTrait;
import com.hbm.handler.pollution.PollutionType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FT_Polluting
extends FluidTrait {
    public HashMap<PollutionType, Float> releaseMap = new HashMap();
    public HashMap<PollutionType, Float> burnMap = new HashMap();

    public FT_Polluting release(PollutionType type, float amount) {
        this.releaseMap.put(type, Float.valueOf(amount));
        return this;
    }

    public FT_Polluting burn(PollutionType type, float amount) {
        this.burnMap.put(type, Float.valueOf(amount));
        return this;
    }

    @Override
    public void addInfo(List<Component> info) {
        info.add((Component)Component.m_237115_((String)HBMLang.FT_POLLUTION1.key()).m_130940_(ChatFormatting.GOLD));
    }

    @Override
    public void addInfoHidden(List<Component> info) {
        if (!this.releaseMap.isEmpty()) {
            info.add((Component)Component.m_237115_((String)HBMLang.FT_POLLUTION2.key()).m_130940_(ChatFormatting.GREEN));
            for (Map.Entry<PollutionType, Float> entry : this.releaseMap.entrySet()) {
                info.add((Component)Component.m_237110_((String)HBMLang.FT_PER_MB.key(), (Object[])new Object[]{entry.getValue(), entry.getKey()}).m_130940_(ChatFormatting.GREEN));
            }
        }
        if (!this.burnMap.isEmpty()) {
            info.add((Component)Component.m_237115_((String)HBMLang.FT_POLLUTION3.key()).m_130940_(ChatFormatting.RED));
            for (Map.Entry<PollutionType, Float> entry : this.burnMap.entrySet()) {
                info.add((Component)Component.m_237110_((String)HBMLang.FT_PER_MB.key(), (Object[])new Object[]{entry.getValue(), entry.getKey()}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    @Override
    public void onFluidRelease(Level world, BlockPos pos, FluidTank tank, int overflowAmount, FluidTrait.FluidReleaseType type) {
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("release").beginObject();
        for (Map.Entry<PollutionType, Float> entry : this.releaseMap.entrySet()) {
            writer.name(entry.getKey().name()).value((Number)entry.getValue());
        }
        writer.endObject();
        writer.name("burn").beginObject();
        for (Map.Entry<PollutionType, Float> entry : this.burnMap.entrySet()) {
            writer.name(entry.getKey().name()).value((Number)entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        JsonObject release;
        if (obj.has("release")) {
            release = obj.get("release").getAsJsonObject();
            for (PollutionType type : PollutionType.values()) {
                if (!release.has(type.name())) continue;
                this.releaseMap.put(type, Float.valueOf(release.get(type.name()).getAsFloat()));
            }
        }
        if (obj.has("burn")) {
            release = obj.get("burn").getAsJsonObject();
            for (PollutionType type : PollutionType.values()) {
                if (!release.has(type.name())) continue;
                this.burnMap.put(type, Float.valueOf(release.get(type.name()).getAsFloat()));
            }
        }
    }

    public static void pollute(Level world, int x, int y, int z, ExtendedFluidType type, FluidTrait.FluidReleaseType release, float mB) {
        FT_Polluting trait = type.getTrait(FT_Polluting.class);
        if (trait == null) {
            return;
        }
        if (release == FluidTrait.FluidReleaseType.VOID) {
            return;
        }
        HashMap<PollutionType, Float> map = release == FluidTrait.FluidReleaseType.BURN ? trait.burnMap : trait.releaseMap;
        for (Map.Entry<PollutionType, Float> entry : map.entrySet()) {
        }
    }
}

