/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hbm.HBM;
import com.hbm.Inventory.recipe.HBMRecipeMatcher;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.Inventory.recipe.RecipeHelper;
import com.hbm.blockentity.machine.AssemblerEntity;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class AssemblerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    final int processingTime;
    public final ItemStack result;
    public final NonNullList<CountableIngredient> ingredients;
    static final int MAX_SIZE = 12;

    public AssemblerRecipe(ResourceLocation id, ItemStack result, NonNullList<CountableIngredient> ingredients) {
        this(id, 100000, result, ingredients);
    }

    public AssemblerRecipe(ResourceLocation id, int processingTime, ItemStack result, NonNullList<CountableIngredient> ingredients) {
        this.id = id;
        this.processingTime = processingTime;
        this.result = result;
        this.ingredients = ingredients;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.ingredients.size();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.ASSEMBLER.type().get();
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pContainer instanceof AssemblerEntity) {
            AssemblerEntity entity = (AssemblerEntity)pContainer;
            boolean cnt = false;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (int i : AssemblerEntity.ASSEMBLE_SLOTS) {
                if (((ItemStack)entity.items.get(i)).m_41619_()) continue;
                inputs.add((ItemStack)entity.items.get(i));
            }
            return inputs.size() >= this.ingredients.size() && HBMRecipeMatcher.orderlessMatch(inputs, this.ingredients);
        }
        return false;
    }

    public boolean checkItem(ItemStack itemStack) {
        for (CountableIngredient ingredient : this.ingredients) {
            if (!ingredient.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        if (pContainer instanceof AssemblerEntity) {
            AssemblerEntity entity = (AssemblerEntity)pContainer;
            block0: for (CountableIngredient ingredient : this.ingredients) {
                int tempCount = ingredient.value.count;
                for (int i : AssemblerEntity.ASSEMBLE_SLOTS) {
                    ItemStack itemStack = (ItemStack)entity.items.get(i);
                    if ((!ingredient.value.flagTag || !itemStack.m_204117_(ingredient.value.tagKey)) && (ingredient.value.flagTag || !itemStack.m_150930_(ingredient.value.itemStack.m_41720_()))) continue;
                    int subsCount = Math.min(tempCount, itemStack.m_41613_());
                    itemStack.m_41774_(subsCount);
                    if (itemStack.m_41619_()) {
                        entity.items.set(i, (Object)ItemStack.f_41583_);
                    } else {
                        entity.items.set(i, (Object)itemStack);
                    }
                    if ((tempCount -= subsCount) == 0) continue block0;
                }
            }
        }
        return this.result.m_41777_();
    }

    public static class Serializer
    implements RecipeSerializer<AssemblerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final ResourceLocation NAME = HBM.rl("assembler_recipe");

        public AssemblerRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            NonNullList<CountableIngredient> nonnulllist = RecipeHelper.itemsFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for assembler recipe");
            }
            if (nonnulllist.size() > 12) {
                throw new JsonParseException("Too many ingredients for assembler recipe. The maximum is 12");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            int processingTime = GsonHelper.m_13927_((JsonObject)pJson, (String)"number");
            return new AssemblerRecipe(pRecipeId, processingTime, itemstack, nonnulllist);
        }

        public AssemblerRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int i = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)((Object)CountableIngredient.EMPTY));
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)CountableIngredient.Serializer.INSTANCE.parse(pBuffer));
            }
            ItemStack itemstack = pBuffer.m_130267_();
            int processingTime = pBuffer.readInt();
            return new AssemblerRecipe(pRecipeId, processingTime, itemstack, (NonNullList<CountableIngredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, AssemblerRecipe pRecipe) {
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (CountableIngredient ingredient : pRecipe.ingredients) {
                CountableIngredient.Serializer.INSTANCE.write(pBuffer, ingredient);
            }
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.writeInt(pRecipe.processingTime);
        }
    }
}

