/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.google.common.collect.Maps;
import com.hbm.item.research.ItemBreedingRod;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class BreederRecipes {
    private static final Map<Object, BreederRecipe> RECIPES = Maps.newHashMap();

    private BreederRecipes() {
    }

    private static void registerDefaults() {
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.LITHIUM, ItemBreedingRod.RodType.TRITIUM, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.CO, ItemBreedingRod.RodType.CO60, 100);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.RA226, ItemBreedingRod.RodType.AC227, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.TH232, ItemBreedingRod.RodType.THF, 500);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.U235, ItemBreedingRod.RodType.NP237, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.NP237, ItemBreedingRod.RodType.PU238, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.PU238, ItemBreedingRod.RodType.PU239, 1000);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.U238, ItemBreedingRod.RodType.RGP, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.URANIUM, ItemBreedingRod.RodType.RGP, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.RodType.RGP, ItemBreedingRod.RodType.WASTE, 200);
    }

    private static void setRecipe(ItemBreedingRod.RodType in, ItemBreedingRod.RodType out, int flux) {
        BreederRecipes.addRodRecipe(ItemBreedingRod.RodForm.SINGLE, in, out, flux);
        BreederRecipes.addRodRecipe(ItemBreedingRod.RodForm.DUAL, in, out, flux * 2);
        BreederRecipes.addRodRecipe(ItemBreedingRod.RodForm.QUAD, in, out, flux * 3);
    }

    private static void addRodRecipe(ItemBreedingRod.RodForm form, ItemBreedingRod.RodType in, ItemBreedingRod.RodType out, int flux) {
        RECIPES.put(new RodKey(in, form), BreederRecipe.ofRod(out, form, flux));
    }

    public static BreederRecipe getOutput(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemBreedingRod) {
            ItemBreedingRod rod = (ItemBreedingRod)item;
            ItemBreedingRod.RodType type = ItemBreedingRod.getType(stack);
            return RECIPES.get(new RodKey(type, rod.getForm()));
        }
        return RECIPES.get(new ItemKey(stack.m_41720_()));
    }

    static {
        BreederRecipes.registerDefaults();
    }

    public record RodKey(ItemBreedingRod.RodType type, ItemBreedingRod.RodForm form) {
    }

    public static class BreederRecipe {
        private final ItemBreedingRod.RodType rodType;
        private final ItemBreedingRod.RodForm form;
        private final ItemStack staticOutput;
        private final int flux;

        private BreederRecipe(ItemBreedingRod.RodType rodType, ItemBreedingRod.RodForm form, ItemStack staticOutput, int flux) {
            this.rodType = rodType;
            this.form = form;
            this.staticOutput = staticOutput;
            this.flux = flux;
        }

        public static BreederRecipe ofRod(ItemBreedingRod.RodType output, ItemBreedingRod.RodForm form, int flux) {
            return new BreederRecipe(output, form, ItemStack.f_41583_, flux);
        }

        public static BreederRecipe ofStatic(ItemStack stack, int flux) {
            return new BreederRecipe(null, null, stack.m_41777_(), flux);
        }

        public int flux() {
            return this.flux;
        }

        public ItemStack createOutput(ItemStack input) {
            if (!this.staticOutput.m_41619_()) {
                return this.staticOutput.m_41777_();
            }
            ItemStack stack = ItemBreedingRod.createStack(this.form, Objects.requireNonNull(this.rodType));
            if (input.m_41782_()) {
                stack.m_41751_(input.m_41783_().m_6426_());
            }
            ItemBreedingRod.setType(stack, this.rodType);
            return stack;
        }

        public ItemStack consumeInput(ItemStack input) {
            ItemStack copy = input.m_41777_();
            copy.m_41774_(1);
            return copy.m_41619_() ? ItemStack.f_41583_ : copy;
        }
    }

    public record ItemKey(Item item) {
    }
}

