/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.google.gson.JsonObject;
import com.hbm.Inventory.recipe.HBMRecipeMatcher;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.Inventory.recipe.RecipeHelper;
import com.hbm.blockentity.machine.ChemplantEntity;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import com.hbm.datagen.recipe.ingredient.FluidStackIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ChemplantRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    final int duration;
    public final List<ItemStack> resultItems;
    public final List<FluidStack> resultFLuids;
    final NonNullList<CountableIngredient> inputItems;
    final NonNullList<FluidStackIngredient> inputFluids;
    static final int MAX_SIZE = 4;
    static final Serializer SERIALIZER = new Serializer();

    public ChemplantRecipe(ResourceLocation id, int duration, List<ItemStack> resultItems, List<FluidStack> resultFLuids, NonNullList<CountableIngredient> inputItems, NonNullList<FluidStackIngredient> inputFluids) {
        this.id = id;
        this.duration = duration;
        this.resultItems = resultItems;
        this.resultFLuids = resultFLuids;
        this.inputItems = inputItems;
        this.inputFluids = inputFluids;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pContainer instanceof ChemplantEntity) {
            ChemplantEntity chemplantEntity = (ChemplantEntity)pContainer;
            return HBMRecipeMatcher.orderlessItemMatch(chemplantEntity.items.subList(12, 16), this.inputItems) && HBMRecipeMatcher.orderlessFluidMatch(chemplantEntity.getFluidTanks(null).subList(0, 2), this.inputFluids);
        }
        return false;
    }

    public void assemble(Container pContainer) {
        if (pContainer instanceof ChemplantEntity) {
            ChemplantEntity chemplantEntity = (ChemplantEntity)pContainer;
            HBMRecipeMatcher.deductItems(chemplantEntity.items.subList(12, 16), this.inputItems);
            HBMRecipeMatcher.deductFluids(chemplantEntity.getFluidTanks(null).subList(0, 2), this.inputFluids);
            HBMRecipeMatcher.putResultItems(chemplantEntity.items.subList(4, 8), this.resultItems);
            HBMRecipeMatcher.putResultFluids(chemplantEntity.getFluidTanks(null).subList(2, 4), this.resultFLuids);
        }
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return null;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.inputItems.size();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return null;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.CHEMPLANT.type().get();
    }

    public int getDuration() {
        return this.duration;
    }

    public static class Serializer
    implements RecipeSerializer<ChemplantRecipe> {
        public ChemplantRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            NonNullList<CountableIngredient> inputItems = RecipeHelper.itemsFromJson(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"inputItems"));
            NonNullList<FluidStackIngredient> inputFluids = RecipeHelper.fluidsFromJson(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"inputFluids"));
            List<ItemStack> resultItems = RecipeHelper.itemListFromJson(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"resultItems"));
            List<FluidStack> resultFluids = RecipeHelper.fluidListFromJson(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"resultFluids"));
            int duration = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"duration");
            return new ChemplantRecipe(pRecipeId, duration, resultItems, resultFluids, inputItems, inputFluids);
        }

        @Nullable
        public ChemplantRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int duration = pBuffer.readInt();
            long power = pBuffer.readLong();
            int len = pBuffer.readInt();
            NonNullList inputItems = NonNullList.m_122780_((int)len, (Object)((Object)CountableIngredient.EMPTY));
            for (int i = 0; i < len; ++i) {
                inputItems.set(i, (Object)CountableIngredient.Serializer.INSTANCE.parse(pBuffer));
            }
            len = pBuffer.readInt();
            NonNullList inputFluids = NonNullList.m_122780_((int)len, (Object)FluidStackIngredient.EMPTY);
            for (int i = 0; i < len; ++i) {
                inputFluids.set(i, (Object)FluidStackIngredient.fromNetwork(pBuffer));
            }
            len = pBuffer.readInt();
            ArrayList<ItemStack> resultItems = new ArrayList<ItemStack>(List.of());
            for (int i = 0; i < len; ++i) {
                resultItems.add(pBuffer.m_130267_());
            }
            len = pBuffer.readInt();
            ArrayList<FluidStack> resultFLuids = new ArrayList<FluidStack>(List.of());
            for (int i = 0; i < len; ++i) {
                resultFLuids.add(pBuffer.readFluidStack());
            }
            return new ChemplantRecipe(pRecipeId, duration, resultItems, resultFLuids, (NonNullList<CountableIngredient>)inputItems, (NonNullList<FluidStackIngredient>)inputFluids);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ChemplantRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.duration);
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (CountableIngredient countableIngredient : pRecipe.inputItems) {
                CountableIngredient.Serializer.INSTANCE.write(pBuffer, countableIngredient);
            }
            pBuffer.writeInt(pRecipe.inputFluids.size());
            for (FluidStackIngredient fluidStackIngredient : pRecipe.inputFluids) {
                FluidStackIngredient.toNetwork(pBuffer, fluidStackIngredient);
            }
            pBuffer.writeInt(pRecipe.resultItems.size());
            for (ItemStack itemStack : pRecipe.resultItems) {
                pBuffer.m_130055_(itemStack);
            }
            pBuffer.writeInt(pRecipe.resultFLuids.size());
            for (FluidStack fluidStack : pRecipe.resultFLuids) {
                pBuffer.writeFluidStack(fluidStack);
            }
        }
    }
}

