/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.hbm.Inventory.fluid.ModFluids;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class CrackingRecipes {
    public static final int INPUT_CONSUMPTION = 100;
    public static final int STEAM_CONSUMPTION = 200;
    public static final int SPENT_STEAM_OUTPUT = 2;
    private static final Map<Fluid, RecipeOutput> RECIPES = new HashMap<Fluid, RecipeOutput>();

    private CrackingRecipes() {
    }

    public static void registerDefaults() {
        RECIPES.clear();
        CrackingRecipes.put((Fluid)ModFluids.OIL.source().get(), CrackingRecipes.stack((Fluid)ModFluids.CRACK_OIL.source().get(), 80), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 20));
        CrackingRecipes.put((Fluid)ModFluids.BITUMEN.source().get(), CrackingRecipes.stack((Fluid)ModFluids.OIL.source().get(), 80), CrackingRecipes.stack((Fluid)ModFluids.AROMATICS.source().get(), 20));
        CrackingRecipes.put((Fluid)ModFluids.SMEAR.source().get(), CrackingRecipes.stack((Fluid)ModFluids.NAPHTHA.source().get(), 60), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 40));
        CrackingRecipes.put((Fluid)ModFluids.REFINERY_GAS.source().get(), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 30), CrackingRecipes.stack((Fluid)ModFluids.UNSATURATEDS.source().get(), 20));
        CrackingRecipes.put((Fluid)ModFluids.DIESEL.source().get(), CrackingRecipes.stack((Fluid)ModFluids.KEROSENE.source().get(), 40), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 30));
        CrackingRecipes.put((Fluid)ModFluids.DIESEL_CRACK.source().get(), CrackingRecipes.stack((Fluid)ModFluids.KEROSENE.source().get(), 40), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 30));
        CrackingRecipes.put((Fluid)ModFluids.KEROSENE.source().get(), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 60), FluidStack.EMPTY);
        CrackingRecipes.put((Fluid)ModFluids.WOOD_OIL.source().get(), CrackingRecipes.stack((Fluid)ModFluids.HEATING_OIL.source().get(), 40), CrackingRecipes.stack((Fluid)ModFluids.AROMATICS.source().get(), 10));
        CrackingRecipes.put((Fluid)ModFluids.NAPHTHA.source().get(), CrackingRecipes.stack((Fluid)ModFluids.AROMATICS.source().get(), 80), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 20));
        CrackingRecipes.put((Fluid)ModFluids.HEATING_OIL_VACUUM.source().get(), CrackingRecipes.stack((Fluid)ModFluids.HEATING_OIL.source().get(), 80), CrackingRecipes.stack((Fluid)ModFluids.REFORM_GAS.source().get(), 20));
        CrackingRecipes.put((Fluid)ModFluids.REFORMATE.source().get(), CrackingRecipes.stack((Fluid)ModFluids.UNSATURATEDS.source().get(), 40), CrackingRecipes.stack((Fluid)ModFluids.REFORM_GAS.source().get(), 60));
        CrackingRecipes.put((Fluid)ModFluids.BIOGAS.source().get(), CrackingRecipes.stack((Fluid)ModFluids.PETROLEUM.source().get(), 20), CrackingRecipes.stack((Fluid)ModFluids.AROMATICS.source().get(), 20));
    }

    private static FluidStack stack(Fluid fluid, int amount) {
        return new FluidStack(fluid, amount);
    }

    private static void put(Fluid input, FluidStack left, FluidStack right) {
        RECIPES.put(input, new RecipeOutput(left, right));
    }

    public static Optional<RecipeOutput> get(Fluid fluid) {
        return Optional.ofNullable(RECIPES.get(fluid));
    }

    public static Map<Fluid, RecipeOutput> entries() {
        return Collections.unmodifiableMap(RECIPES);
    }

    public record RecipeOutput(FluidStack left, FluidStack right) {
    }
}

