/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import com.hbm.datagen.recipe.ingredient.FluidStackIngredient;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HBMRecipeMatcher {
    public static <T extends ItemStack> boolean orderlessMatch(List<T> inputs, List<? extends CountableIngredient> tests) {
        int inputSize = inputs.size();
        BitSet bitSet = new BitSet(inputSize);
        for (CountableIngredient countableIngredient : tests) {
            int count = countableIngredient.value.count;
            for (int i = 0; i < inputSize; ++i) {
                ItemStack input;
                if (bitSet.get(i) || !countableIngredient.test(input = (ItemStack)inputs.get(i))) continue;
                bitSet.set(i);
                if ((count -= input.m_41613_()) <= 0) break;
            }
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends ItemStack> boolean orderlessItemMatch(List<T> inputs, List<? extends CountableIngredient> tests) {
        HashMap<ItemLike, Integer> countAll = new HashMap<ItemLike, Integer>();
        for (ItemStack itemStack : inputs) {
            countAll.compute((ItemLike)itemStack.m_41720_(), (k, v) -> v == null ? input.m_41613_() : input.m_41613_() + v);
        }
        for (CountableIngredient countableIngredient : tests) {
            Integer cnt;
            if (!(!countableIngredient.value.flagTag ? !countAll.containsKey(countableIngredient.value.itemStack.m_41720_()) || countableIngredient.value.count > (Integer)countAll.get(countableIngredient.value.itemStack.m_41720_()) : (cnt = countAll.keySet().stream().reduce(0, (sum, item) -> ingredient.test(new ItemStack(item)) ? sum + (Integer)countAll.get(item) : sum, Integer::sum)) < countableIngredient.value.count)) continue;
            return false;
        }
        return true;
    }

    public static <T extends IFluidTank> boolean orderlessFluidMatch(List<T> inputs, List<? extends FluidStackIngredient> tests) {
        HashMap<Fluid, Integer> countAll = new HashMap<Fluid, Integer>();
        for (IFluidTank iFluidTank : inputs) {
            FluidStack fluid2 = iFluidTank.getFluid();
            countAll.compute(fluid2.getFluid(), (k, v) -> v == null ? fluid2.getAmount() : fluid2.getAmount() + v);
        }
        for (FluidStackIngredient fluidStackIngredient : tests) {
            Integer cnt;
            if (!(!fluidStackIngredient.flagTag ? !countAll.containsKey(fluidStackIngredient.fluidStack.getFluid()) || fluidStackIngredient.volume > (Integer)countAll.get(fluidStackIngredient.fluidStack.getFluid()) : (cnt = countAll.keySet().stream().reduce(0, (sum, fluid) -> ingredient.test(new FluidStack(fluid, 1)) ? sum + (Integer)countAll.get(fluid) : sum, Integer::sum)) < fluidStackIngredient.volume)) continue;
            return false;
        }
        return true;
    }

    public static <T extends ItemStack> void deductItems(List<T> inputSlots, List<? extends CountableIngredient> toDeduct) {
        block0: for (CountableIngredient countableIngredient : toDeduct) {
            int tempCount = countableIngredient.value.count;
            for (int i = 0; i < inputSlots.size(); ++i) {
                ItemStack slot = (ItemStack)inputSlots.get(i);
                if ((!countableIngredient.value.flagTag || !slot.m_204117_(countableIngredient.value.tagKey)) && (countableIngredient.value.flagTag || !slot.m_150930_(countableIngredient.value.itemStack.m_41720_()))) continue;
                int subsCount = Math.min(tempCount, slot.m_41613_());
                slot.m_41774_(subsCount);
                if (slot.m_41619_()) {
                    slot = ItemStack.f_41583_;
                }
                inputSlots.set(i, slot);
                if ((tempCount -= subsCount) == 0) continue block0;
            }
        }
    }

    public static <T extends ItemStack> boolean checkOutputSlots(List<T> outputSlots, List<T> resultItems) {
        int emptySlotNum = 0;
        HashMap<ItemLike, Integer> countAll = new HashMap<ItemLike, Integer>();
        HashMap<ItemLike, Integer> targetMap = new HashMap<ItemLike, Integer>();
        resultItems.forEach(stack -> targetMap.compute((ItemLike)stack.m_41720_(), (k, v) -> v == null ? 0 : v + stack.m_41613_()));
        for (ItemStack itemStack : outputSlots) {
            if (!itemStack.m_41619_()) {
                countAll.compute((ItemLike)itemStack.m_41720_(), (k, v) -> v == null ? stack2.m_41741_() - stack2.m_41613_() : v + stack2.m_41741_() - stack2.m_41613_());
                continue;
            }
            ++emptySlotNum;
        }
        for (Map.Entry entry : targetMap.entrySet()) {
            ItemLike item = (ItemLike)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if ((count = Integer.valueOf(count - Math.min(count, countAll.getOrDefault(item, 0)))) > 0) {
                int maxStackSize = item.m_5456_().m_41459_();
                if ((emptySlotNum -= count / maxStackSize + 1) < 0) {
                    return false;
                }
            }
            targetMap.put(item, count);
        }
        return true;
    }

    public static <T extends ItemStack> void putResultItems(List<T> outputSlots, List<T> resultItems) {
        block0: for (ItemStack resultItem : resultItems) {
            int temp = resultItem.m_41613_();
            for (int i = 0; i < outputSlots.size(); ++i) {
                ItemStack slot = (ItemStack)outputSlots.get(i);
                if (slot.m_150930_(resultItem.m_41720_())) {
                    insertNum = Math.min(resultItem.m_41741_() - slot.m_41613_(), temp);
                    slot.m_41769_(insertNum);
                    temp -= insertNum;
                } else if (slot.m_41619_()) {
                    insertNum = Math.min(resultItem.m_41741_(), temp);
                    outputSlots.set(i, resultItem.m_255036_(insertNum));
                    temp -= insertNum;
                }
                if (temp == 0) continue block0;
            }
        }
    }

    public static <T extends IFluidTank> void deductFluids(List<T> inputSlots, List<? extends FluidStackIngredient> toDeduct) {
        block0: for (FluidStackIngredient fluidStackIngredient : toDeduct) {
            int tempCount = fluidStackIngredient.volume;
            for (int i = 0; i < inputSlots.size(); ++i) {
                FluidStack slot = ((IFluidTank)inputSlots.get(i)).getFluid();
                if ((!fluidStackIngredient.flagTag || !slot.getFluid().m_205067_(fluidStackIngredient.tagKey)) && (fluidStackIngredient.flagTag || !slot.isFluidEqual(fluidStackIngredient.fluidStack))) continue;
                int subsCount = Math.min(tempCount, slot.getAmount());
                ((IFluidTank)inputSlots.get(i)).drain(subsCount, IFluidHandler.FluidAction.EXECUTE);
                if ((tempCount -= subsCount) == 0) continue block0;
            }
        }
    }

    public static <T extends IFluidTank> boolean checkOutputTanks(List<T> outputTanks, List<FluidStack> resultFluids) {
        HashMap<Fluid, Integer> countAll = new HashMap<Fluid, Integer>();
        HashMap<Fluid, Integer> targetMap = new HashMap<Fluid, Integer>();
        LinkedList<IFluidTank> emptyTanks = new LinkedList<IFluidTank>();
        resultFluids.forEach(stack -> targetMap.compute(stack.getFluid(), (k, v) -> v == null ? 0 : v + stack.getAmount()));
        for (IFluidTank iFluidTank : outputTanks) {
            if (!iFluidTank.getFluid().isEmpty()) {
                countAll.compute(iFluidTank.getFluid().getFluid(), (k, v) -> v == null ? tank.getCapacity() - tank.getFluidAmount() : v + tank.getCapacity() - tank.getFluidAmount());
                continue;
            }
            emptyTanks.addFirst(iFluidTank);
        }
        for (Map.Entry entry : targetMap.entrySet()) {
            Fluid fluid = (Fluid)entry.getKey();
            Integer count = (Integer)entry.getValue();
            count = count - Math.min(count, countAll.getOrDefault(fluid, 0));
            while (count > 0) {
                IFluidTank first = (IFluidTank)emptyTanks.peekFirst();
                if (first == null) {
                    return false;
                }
                count = count - Math.min(count, first.getCapacity());
                emptyTanks.pollFirst();
            }
            targetMap.put(fluid, count);
        }
        return true;
    }

    public static <T extends IFluidTank> void putResultFluids(List<T> outputTanks, List<FluidStack> resultFluids) {
        block0: for (FluidStack resultFluid : resultFluids) {
            int temp = resultFluid.getAmount();
            for (int i = 0; i < outputTanks.size(); ++i) {
                IFluidTank tank = (IFluidTank)outputTanks.get(i);
                if (tank.getFluid().isFluidEqual(resultFluid) || tank.getFluid().isEmpty()) {
                    int insertVol = Math.min(tank.getCapacity() - tank.getFluidAmount(), temp);
                    tank.fill(new FluidStack(resultFluid, insertVol), IFluidHandler.FluidAction.EXECUTE);
                    temp -= insertVol;
                }
                if (temp == 0) continue block0;
            }
        }
    }
}

