/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.hbm.Inventory.recipe.AssemblerRecipe;
import com.hbm.Inventory.recipe.BlastFurnaceRecipe;
import com.hbm.Inventory.recipe.ChemplantRecipe;
import com.hbm.Inventory.recipe.PWRFuelPrinterRecipe;
import com.hbm.Inventory.recipe.ShredderRecipe;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModRecipes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"hbm");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"hbm");
    public static final RecipeHolder<BlastFurnaceRecipe> BLAST = ModRecipes.register("blast", BlastFurnaceRecipe.Serializer.INSTANCE);
    public static final RecipeHolder<AssemblerRecipe> ASSEMBLER = ModRecipes.register("assembler", AssemblerRecipe.Serializer.INSTANCE);
    public static final RecipeHolder<ChemplantRecipe> CHEMPLANT = ModRecipes.register("chemplant", ChemplantRecipe.SERIALIZER);
    public static final RecipeHolder<ShredderRecipe> SHREDDER = ModRecipes.register("shredder", ShredderRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<PWRFuelPrinterRecipe>> PWR_FUEL_PRINTER = SERIALIZER.register("pwr_fuel_printer", () -> new SimpleCraftingRecipeSerializer(PWRFuelPrinterRecipe::new));

    static <T extends Recipe<Container>> RecipeType<T> register(final String pIdentifier) {
        return new RecipeType<T>(){

            public String toString() {
                return pIdentifier;
            }
        };
    }

    static <T extends Recipe<Container>> RecipeHolder<T> register(String pIdentifier, RecipeSerializer<T> serializer) {
        RegistryObject recipeType = RECIPE_TYPE.register(pIdentifier, () -> ModRecipes.register(pIdentifier));
        RegistryObject recipeSerializer = SERIALIZER.register(pIdentifier, () -> serializer);
        return new RecipeHolder(recipeType, recipeSerializer);
    }

    public record RecipeHolder<T extends Recipe<?>>(RegistryObject<RecipeType<T>> type, RegistryObject<RecipeSerializer<T>> serializer) {
    }
}

