/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.item.HBMItems;
import com.hbm.item.pwr.ItemPWRFuel;
import com.hbm.reactor.pwr.PWRFuelType;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class PWRFuelPrinterRecipe
extends CustomRecipe {
    private static final Map<RegistryObject<Item>, PWRFuelType> FUEL_MAP = new LinkedHashMap<RegistryObject<Item>, PWRFuelType>();

    public PWRFuelPrinterRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean foundPrinter = false;
        ItemStack billetStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)HBMItems.pwr_printer.get())) {
                if (foundPrinter) {
                    return false;
                }
                foundPrinter = true;
                continue;
            }
            if (PWRFuelPrinterRecipe.getFuelType(stack) != null) {
                if (!billetStack.m_41619_()) {
                    return false;
                }
                billetStack = stack;
                continue;
            }
            return false;
        }
        return foundPrinter && !billetStack.m_41619_();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack billetStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || PWRFuelPrinterRecipe.getFuelType(stack) == null) continue;
            billetStack = stack;
            break;
        }
        if (billetStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        PWRFuelType type = PWRFuelPrinterRecipe.getFuelType(billetStack);
        if (type == null) {
            return ItemStack.f_41583_;
        }
        return ItemPWRFuel.createStack((Item)HBMItems.pwr_fuel.get(), type);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remaining = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_150930_((Item)HBMItems.pwr_printer.get())) continue;
            remaining.set(i, (Object)stack.m_41777_());
        }
        return remaining;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.PWR_FUEL_PRINTER.get();
    }

    private static PWRFuelType getFuelType(ItemStack stack) {
        for (Map.Entry<RegistryObject<Item>, PWRFuelType> entry : FUEL_MAP.entrySet()) {
            if (!stack.m_150930_((Item)entry.getKey().get())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        FUEL_MAP.put(HBMItems.BILLET_URANIUM_FUEL, PWRFuelType.MEU);
        FUEL_MAP.put(HBMItems.BILLET_U233, PWRFuelType.HEU233);
        FUEL_MAP.put(HBMItems.BILLET_U235, PWRFuelType.HEU235);
        FUEL_MAP.put(HBMItems.BILLET_NEPTUNIUM_FUEL, PWRFuelType.MEN);
        FUEL_MAP.put(HBMItems.BILLET_NEPTUNIUM, PWRFuelType.HEN237);
        FUEL_MAP.put(HBMItems.BILLET_MOX_FUEL, PWRFuelType.MOX);
        FUEL_MAP.put(HBMItems.BILLET_PLUTONIUM_FUEL, PWRFuelType.MEP);
        FUEL_MAP.put(HBMItems.BILLET_PU239, PWRFuelType.HEP239);
        FUEL_MAP.put(HBMItems.BILLET_PU241, PWRFuelType.HEP241);
        FUEL_MAP.put(HBMItems.BILLET_AMERICIUM_FUEL, PWRFuelType.MEA);
        FUEL_MAP.put(HBMItems.BILLET_AM242, PWRFuelType.HEA242);
        FUEL_MAP.put(HBMItems.BILLET_SCHRABIDIUM_FUEL, PWRFuelType.HES326);
        FUEL_MAP.put(HBMItems.BILLET_HES, PWRFuelType.HES327);
        FUEL_MAP.put(HBMItems.BILLET_ZFB_AM_MIX, PWRFuelType.BFB_AM_MIX);
        FUEL_MAP.put(HBMItems.BILLET_ZFB_PU241, PWRFuelType.BFB_PU241);
    }
}

