/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import com.hbm.datagen.recipe.ingredient.FluidStackIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHelper {
    public static NonNullList<CountableIngredient> itemsFromJson(JsonArray pIngredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            CountableIngredient ingredient;
            if (pIngredientArray.get(i).isJsonObject()) {
                ingredient = CountableIngredient.Serializer.INSTANCE.parse(pIngredientArray.get(i).getAsJsonObject());
                if (ingredient.m_43947_()) {
                    throw new JsonSyntaxException("Parse wrong : Ingredient is empty.");
                }
            } else {
                throw new JsonSyntaxException("Parse wrong : CountableIngredient must be read from JsonObject.");
            }
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static NonNullList<FluidStackIngredient> fluidsFromJson(JsonArray pIngredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            FluidStackIngredient ingredient;
            if (pIngredientArray.get(i).isJsonObject()) {
                ingredient = FluidStackIngredient.fromJson(pIngredientArray.get(i).getAsJsonObject());
                if (ingredient.isEmpty()) {
                    throw new JsonSyntaxException("Parse wrong : Ingredient is empty.");
                }
            } else {
                throw new JsonSyntaxException("Parse wrong : FluidStackIngredient must be read from JsonObject.");
            }
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static List<ItemStack> itemListFromJson(JsonArray pIngredientArray) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            int count;
            Item item;
            if (pIngredientArray.get(i).isJsonObject()) {
                JsonObject jsonObject = pIngredientArray.get(i).getAsJsonObject();
                String s = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item");
                item = (Item)BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
                count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
                if (item == null) {
                    throw new JsonSyntaxException("Parse wrong : Ingredient is empty.");
                }
            } else {
                throw new JsonSyntaxException("Parse wrong : CountableIngredient must be read from JsonObject.");
            }
            result.add(new ItemStack((ItemLike)item, count));
        }
        return result;
    }

    public static List<FluidStack> fluidListFromJson(JsonArray pIngredientArray) {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            int volume;
            Fluid fluid;
            if (pIngredientArray.get(i).isJsonObject()) {
                JsonObject jsonObject = pIngredientArray.get(i).getAsJsonObject();
                String s = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fluids");
                fluid = (Fluid)BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
                volume = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"volume", (int)1000);
                if (fluid == null) {
                    throw new JsonSyntaxException("Parse wrong : Ingredient is empty.");
                }
            } else {
                throw new JsonSyntaxException("Parse wrong : CountableIngredient must be read from JsonObject.");
            }
            result.add(new FluidStack(fluid, volume));
        }
        return result;
    }

    public static Fluid fluidFromJson(JsonObject json) {
        String s = GsonHelper.m_13906_((JsonObject)json, (String)"fluids");
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown fluid '" + s + "'"));
        if (fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return fluid;
    }
}

