/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.Inventory.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ShredderRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final CountableIngredient ingredient;
    private final ItemStack result;
    private final int processTime;

    public ShredderRecipe(ResourceLocation id, CountableIngredient ingredient, ItemStack result, int processTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.processTime = processTime;
    }

    public CountableIngredient getIngredient() {
        return this.ingredient;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean matches(ItemStack stack) {
        return !stack.m_41619_() && this.ingredient.test(stack) && stack.m_41613_() >= this.ingredient.value.count;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.matches(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.SHREDDER.type().get();
    }

    public ItemStack getOutput() {
        return this.result.m_41777_();
    }

    public int getIngredientCount() {
        return this.ingredient.value.count;
    }

    public static class Serializer
    implements RecipeSerializer<ShredderRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ShredderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            CountableIngredient ingredient;
            if (!(json.has("item") || json.has("tag") || json.has("ingredient"))) {
                throw new JsonParseException("Missing ingredient for shredder recipe '" + String.valueOf(recipeId) + "'");
            }
            if (json.has("ingredient")) {
                ingredient = CountableIngredient.Serializer.INSTANCE.parse(GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            } else {
                JsonObject obj = new JsonObject();
                if (json.has("item")) {
                    obj.add("item", json.get("item"));
                }
                if (json.has("tag")) {
                    obj.add("tag", json.get("tag"));
                }
                obj.addProperty("count", (Number)GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
                ingredient = CountableIngredient.Serializer.INSTANCE.parse(obj);
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)60);
            return new ShredderRecipe(recipeId, ingredient, result, time);
        }

        public ShredderRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CountableIngredient ingredient = CountableIngredient.Serializer.INSTANCE.parse(buffer);
            ItemStack result = buffer.m_130267_();
            int time = buffer.m_130242_();
            return new ShredderRecipe(recipeId, ingredient, result, time);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShredderRecipe recipe) {
            CountableIngredient.Serializer.INSTANCE.write(buffer, recipe.ingredient);
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.processTime);
        }
    }
}

