/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.addational_data;

import com.hbm.HBM;
import com.hbm.addational_data.DataEntry;
import com.hbm.addational_data.chunk.ChunkAdditionalDataProvider;
import com.hbm.addational_data.chunk.IChunkAdditionalData;
import com.hbm.addational_data.chunk.RadiationManager;
import com.hbm.addational_data.entity.EntityAdditionalDataProvider;
import com.hbm.addational_data.entity.EntityEffectHandler;
import com.hbm.addational_data.entity.IEntityAdditionalData;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toclient.S2CEntitySyncPacket;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="hbm")
public class AdditionalDataManager {
    public static final Capability<IEntityAdditionalData> ENTITY_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEntityAdditionalData>(){});
    public static final Capability<IChunkAdditionalData> CHUNK_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkAdditionalData>(){});
    public static final float randomTickProbability = 0.2f;
    public static final float chunkAccessProb = 0.05f;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IEntityAdditionalData.class);
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(ENTITY_DATA).isPresent()) {
            event.addCapability(HBM.rl("addational"), (ICapabilityProvider)new EntityAdditionalDataProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        LevelChunk chunk = (LevelChunk)event.getObject();
        if (!chunk.getCapability(CHUNK_DATA).isPresent()) {
            event.addCapability(HBM.rl("hbmdata_chunk"), (ICapabilityProvider)new ChunkAdditionalDataProvider());
        }
    }

    @SubscribeEvent
    public static void onLevelUpdate(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerLevel level = (ServerLevel)event.level;
            if (level.f_46441_.m_188501_() < 0.05f) {
                level.m_7726_().f_8325_.m_140416_().forEach(chunkHolder -> {
                    LevelChunk fullChunk = chunkHolder.m_212234_();
                    if (fullChunk != null) {
                        AdditionalDataManager.getChunkData(fullChunk).ifPresent(chunkData -> RadiationManager.updateRadiation(level, fullChunk, chunkData));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EntityEffectHandler.onUpdate(event.getEntity());
            AdditionalDataManager.syncEntityData((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void saveEntityData(LevelEvent.Save event) {
        if (!event.getLevel().m_5776_()) {
            ServerLevel level = (ServerLevel)event.getLevel();
            level.m_8583_().forEach(entity -> entity.getCapability(ENTITY_DATA).ifPresent(entityData -> entity.getPersistentData().m_128365_("hbmdata", entityData.serializeNBT())));
        }
    }

    @SubscribeEvent
    public static void loadEntityData(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_() && event.getLevel().m_46749_(event.getEntity().m_20097_())) {
            event.getEntity().getCapability(ENTITY_DATA).ifPresent(entityData -> entityData.deserializeNBT((Tag)((CompoundTag)event.getEntity().getPersistentData().m_128423_("hbmdata"))));
        }
    }

    @SubscribeEvent
    public static void loadPlayerData(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            player.getCapability(ENTITY_DATA).ifPresent(entityData -> entityData.deserializeNBT((Tag)((CompoundTag)player.getPersistentData().m_128423_("hbmdata"))));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(ENTITY_DATA).ifPresent(oldCap -> event.getEntity().getCapability(ENTITY_DATA).ifPresent(newCap -> newCap.copyAfterDeath((IEntityAdditionalData)oldCap)));
    }

    @SubscribeEvent
    public static void saveChunkData(ChunkDataEvent.Save event) {
        ChunkAccess chunk = event.getChunk();
        long chunkId = chunk.m_7697_().m_45588_();
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            levelChunk.getCapability(CHUNK_DATA).ifPresent(chunkData -> event.getData().m_128365_(String.valueOf(chunkId), chunkData.serializeNBT()));
        }
    }

    @SubscribeEvent
    public static void loadChunkData(ChunkDataEvent.Load event) {
        ChunkAccess chunk = event.getChunk();
        long chunkId = chunk.m_7697_().m_45588_();
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            levelChunk.getCapability(CHUNK_DATA).ifPresent(chunkData -> chunkData.deserializeNBT((Tag)event.getData().m_128469_(String.valueOf(chunkId))));
        }
    }

    public static Optional<IEntityAdditionalData> getAdditionalData(Entity entity) {
        return entity.getCapability(ENTITY_DATA).resolve();
    }

    public static Optional<IChunkAdditionalData> getChunkData(LevelChunk chunk) {
        return chunk.getCapability(CHUNK_DATA).resolve();
    }

    public static boolean checkEntityData(Entity entity, DataEntry entry) {
        Optional<IEntityAdditionalData> optional = AdditionalDataManager.getAdditionalData(entity);
        if (optional.isPresent()) {
            IEntityAdditionalData entityData = optional.get();
            return entityData.contains(entry);
        }
        return false;
    }

    public static Optional<?> getEntityData(Entity entity, DataEntry entry) {
        Optional<IEntityAdditionalData> optional = AdditionalDataManager.getAdditionalData(entity);
        if (optional.isPresent()) {
            IEntityAdditionalData entityData = optional.get();
            return entityData.getData(entry);
        }
        return Optional.empty();
    }

    public static Optional<?> getChunkData(LevelChunk chunk, DataEntry entry) {
        Optional<IChunkAdditionalData> optional = AdditionalDataManager.getChunkData(chunk);
        if (optional.isPresent()) {
            IChunkAdditionalData data = optional.get();
            return data.getData(entry);
        }
        return Optional.empty();
    }

    public static void setEntityData(Entity entity, DataEntry dataEntry, @Nullable Object value) {
        AdditionalDataManager.getAdditionalData(entity).ifPresent(data -> data.setData(dataEntry, value));
    }

    public static void setChunkData(LevelChunk chunk, DataEntry dataEntry, @Nullable Object value) {
        AdditionalDataManager.getChunkData(chunk).ifPresent(data -> data.setData(dataEntry, value));
    }

    public static void syncEntityData(Entity entity) {
        AdditionalDataManager.getAdditionalData(entity).ifPresent(entityData -> {
            if (entityData.shouldSync()) {
                ModMessages.sendToEntity(new S2CEntitySyncPacket(entity), entity);
            }
        });
    }
}

