/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.addational_data;

import com.hbm.HBM;
import com.hbm.addational_data.DataEntry;
import com.hbm.addational_data.IAdditionalData;
import com.hbm.utils.NBTUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class BasicAdditionalDataImpl
implements IAdditionalData {
    Map<DataEntry, Object> dataEntries = new HashMap<DataEntry, Object>();
    Map<DataEntry, CompoundTag> tagData = new HashMap<DataEntry, CompoundTag>();
    Set<DataEntry> changed = new HashSet<DataEntry>();

    @Override
    public boolean contains(DataEntry entry) {
        return this.dataEntries.containsKey((Object)entry);
    }

    @Override
    public Map<DataEntry, Object> getEntries() {
        return this.dataEntries;
    }

    public boolean hasEntry(DataEntry entry) {
        return this.dataEntries.containsKey((Object)entry);
    }

    @Override
    public <T> Optional<T> getData(DataEntry entry, Class<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        Object object = this.dataEntries.get((Object)entry);
        if (this.tagData.containsKey((Object)entry)) {
            this.loadPersistentData(entry);
            object = this.dataEntries.get((Object)entry);
        }
        if (type.isInstance(object)) {
            return Optional.of(type.cast(object));
        }
        return Optional.empty();
    }

    @Override
    public void setData(DataEntry entry, @Nullable Object value) {
        Object value2 = this.typeCast(entry.type, value);
        if (entry.type == null && value2 == null || entry.type != null && entry.type.isInstance(value2)) {
            this.dataEntries.put(entry, value2);
            if (entry.needSync) {
                this.markChange(entry);
            }
        }
    }

    @Nullable
    private Object typeCast(Class<?> type, @Nullable Object value) {
        if (type.equals(Float.class)) {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return Float.valueOf(integer.floatValue());
            }
            if (value instanceof Double) {
                Double dou = (Double)value;
                return Float.valueOf(dou.floatValue());
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                return Float.valueOf(l.floatValue());
            }
        }
        return value;
    }

    public void setData(DataEntry entry) {
        this.setData(entry, null);
    }

    public void removeData(DataEntry dataEntry) {
        this.dataEntries.remove((Object)dataEntry);
        this.tagData.remove((Object)dataEntry);
    }

    @Override
    public void markChange(DataEntry entry) {
        this.changed.add(entry);
    }

    @Override
    public boolean shouldSync() {
        return !this.changed.isEmpty();
    }

    @Override
    public CompoundTag syncToClient() {
        CompoundTag tag = new CompoundTag();
        for (DataEntry entry : this.changed) {
            NBTUtils.serializeDataEntry(tag, entry, this.dataEntries.get((Object)entry));
        }
        this.changed.clear();
        return tag;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.dataEntries.forEach((key, val) -> {
            if (key.isPersistent) {
                NBTUtils.serializeDataEntry(tag, key, val);
            }
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        for (String key : nbt.m_128431_()) {
            DataEntry entry = DataEntry.values()[Integer.parseInt(key)];
            if (INBTSerializable.class.isAssignableFrom(entry.type)) {
                this.dataEntries.put(entry, null);
                this.tagData.put(entry, (CompoundTag)nbt.m_128423_("" + entry.ordinal()));
                continue;
            }
            this.dataEntries.put(entry, NBTUtils.deserializeDataEntry(nbt, entry));
        }
    }

    public <T extends INBTSerializable<CompoundTag>> void loadPersistentData(DataEntry entry) {
        if (this.tagData.containsKey((Object)entry)) {
            try {
                INBTSerializable dataHandler = (INBTSerializable)entry.type.newInstance();
                dataHandler.deserializeNBT((Tag)this.tagData.get((Object)entry));
                this.tagData.remove((Object)entry);
                this.dataEntries.put(entry, dataHandler);
            }
            catch (Exception e) {
                HBM.LOGGER.warn("Data entry:{} try invoke deserializeNBT method fail.", (Object)entry);
            }
        }
    }
}

