/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.addational_data.chunk;

import com.hbm.addational_data.AdditionalDataManager;
import com.hbm.addational_data.DataEntry;
import com.hbm.addational_data.chunk.IChunkAdditionalData;
import com.hbm.block.HBMBlockComponent;
import com.hbm.config.RadiationConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class RadiationManager {
    public static final float worldDestructionThreshold = 10.0f;

    public static float getRadiation(Level level, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return 0.0f;
        }
        ChunkAccess chunk = level.m_46865_(blockPos);
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            return AdditionalDataManager.getChunkData(levelChunk, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public static void incrementRadiation(Level level, BlockPos blockPos, float rad) {
        ChunkAccess chunkAccess;
        if (level.m_7232_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4) && (chunkAccess = level.m_46865_(blockPos)) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Float radOld = AdditionalDataManager.getChunkData(chunk, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
            AdditionalDataManager.setChunkData(chunk, DataEntry.RADIATION, Float.valueOf(radOld.floatValue() + rad));
        }
    }

    public static void decrementRadiation(Level level, BlockPos blockPos, float radToSubtract) {
        RadiationManager.incrementRadiation(level, blockPos, -radToSubtract);
    }

    public static void updateRadiation(ServerLevel level, LevelChunk chunk, IChunkAdditionalData chunkData) {
        ChunkPos pos = chunk.m_7697_();
        float rad_add = 0.0f;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (!level.m_7232_(pos.f_45578_ + i, pos.f_45579_ + j) || i + j == 0) continue;
                int dist = i + j;
                LevelChunk neighbourChunk = level.m_6325_(pos.f_45578_ + i, pos.f_45579_ + j);
                Float rad = AdditionalDataManager.getChunkData(neighbourChunk, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
                rad_add += rad.floatValue() * (dist == 1 ? 0.075f : 0.025f);
            }
        }
        float newRad = chunkData.getData(DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue() * 0.6f;
        if (rad_add > 0.0f) {
            if (chunkData.contains(DataEntry.RADIATION)) {
                newRad += rad_add;
            }
            chunkData.setData(DataEntry.RADIATION, Float.valueOf(newRad));
        }
        if (RadiationConfig.worldRadEffects && newRad > 10.0f) {
            for (int a = 0; a < 16; ++a) {
                for (int b = 0; b < 16; ++b) {
                    int z;
                    int y;
                    int x;
                    BlockState blockState;
                    if (level.f_46441_.m_188503_(3) != 0 || (blockState = level.m_8055_(new BlockPos(x = pos.m_151390_() - 8 + a, y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = pos.m_151393_() - 8 + b) - level.f_46441_.m_188503_(2), z))).m_60795_()) continue;
                    if (blockState.m_60713_(Blocks.f_50440_)) {
                        level.m_7731_(new BlockPos(x, y, z), ((Block)HBMBlockComponent.WAST_EARTH.get()).m_49966_(), 3);
                        continue;
                    }
                    if (blockState.m_60713_(Blocks.f_50359_)) {
                        level.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 11);
                        continue;
                    }
                    if (!blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_((Block)HBMBlockComponent.WAST_LEAVES.get())) continue;
                    if (level.f_46441_.m_188503_(7) <= 5) {
                        level.m_7731_(new BlockPos(x, y, z), ((Block)HBMBlockComponent.WAST_LEAVES.get()).m_49966_(), 3);
                        continue;
                    }
                    level.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 11);
                }
            }
        }
    }
}

