/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.addational_data.entity;

import com.hbm.addational_data.AdditionalDataManager;
import com.hbm.addational_data.DataEntry;
import com.hbm.addational_data.chunk.RadiationManager;
import com.hbm.addational_data.entity.IEntityAdditionalData;
import com.hbm.addational_data.entity.living.ContaminationEffectLists;
import com.hbm.config.RadiationConfig;
import com.hbm.effect.ModEffects;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toclient.S2CParticlePacket;
import com.hbm.registries.ModSounds;
import com.hbm.utils.ContaminationUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.PacketDistributor;

public class EntityEffectHandler {
    public static void onUpdate(LivingEntity entity) {
        Player player;
        if (!entity.m_6084_() || entity.m_9236_().f_46443_ || entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        Optional<IEntityAdditionalData> optional = AdditionalDataManager.getAdditionalData((Entity)entity);
        if (optional.isEmpty()) {
            return;
        }
        IEntityAdditionalData entityData = optional.get();
        Level level = entity.m_9236_();
        EntityEffectHandler.handleContamination(entity);
        EntityEffectHandler.handleEnvRadiation(entity, entityData);
        EntityEffectHandler.handleRadiationEffect(entity, entityData);
    }

    private static void handleContamination(LivingEntity entity) {
        ContaminationEffectLists effectLists = AdditionalDataManager.getEntityData((Entity)entity, DataEntry.CONTAMINATION_EFFECTS).map(o -> (ContaminationEffectLists)o).orElse(new ContaminationEffectLists());
        ArrayList<ContaminationEffectLists.ContaminationEffect> rem = new ArrayList<ContaminationEffectLists.ContaminationEffect>();
        for (ContaminationEffectLists.ContaminationEffect con : effectLists.getEffects()) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, con.ignoreArmor ? ContaminationUtil.ContaminationType.RAD_BYPASS : ContaminationUtil.ContaminationType.CREATIVE, con.getRad());
            --con.time;
            if (con.time > 0) continue;
            rem.add(con);
        }
        effectLists.getEffects().removeAll(rem);
    }

    public static void handleEnvRadiation(LivingEntity entity, IEntityAdditionalData entityData) {
        Player player;
        if (ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        Level level = entity.m_9236_();
        float rad = RadiationManager.getRadiation(level, entity.m_20183_());
        if (level.m_46472_().equals((Object)Level.f_46429_) && (double)rad <= RadiationConfig.hellRad) {
            rad = (float)RadiationConfig.hellRad;
        }
        if (rad > 0.0f) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad / 20.0f);
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        Random rand = new Random(entity.m_19879_());
        int r600 = rand.nextInt(600);
        int r1200 = rand.nextInt(1200);
        float entityRad = AdditionalDataManager.getEntityData((Entity)entity, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        if (entityRad > 600.0f) {
            if ((level.m_46467_() + (long)r600) % 600L < 20L && EntityEffectHandler.canVomit(entity)) {
                tag = new CompoundTag();
                tag.m_128359_("type", "vomit");
                tag.m_128359_("mode", "blood");
                tag.m_128405_("count", 25);
                tag.m_128405_("entity", entity.m_19879_());
                ModMessages.sendToAllAround(new S2CParticlePacket(tag, 0.0, 0.0, 0.0), new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25.0, entity.m_9236_().m_46472_()));
                if ((level.m_46467_() + (long)r600) % 600L == 1L) {
                    entity.m_5496_((SoundEvent)ModSounds.PLAYER_VOMIT.get(), 1.0f, 1.0f);
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 19));
                }
            }
        } else if (entityRad > 200.0f && (level.m_46467_() + (long)r1200) % 1200L < 20L && EntityEffectHandler.canVomit(entity)) {
            tag = new CompoundTag();
            tag.m_128359_("type", "vomit");
            tag.m_128359_("mode", "normal");
            tag.m_128405_("count", 15);
            tag.m_128405_("entity", entity.m_19879_());
            ModMessages.sendToAllAround(new S2CParticlePacket(tag, 0.0, 0.0, 0.0), new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25.0, entity.m_9236_().m_46472_()));
            if ((level.m_46467_() + (long)r1200) % 1200L == 1L) {
                entity.m_5496_((SoundEvent)ModSounds.PLAYER_VOMIT.get(), 1.0f, 1.0f);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 19));
            }
        }
        if (entityRad > 900.0f && (level.m_46467_() + (long)rand.nextInt(10)) % 10L == 0L) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "sweat");
            tag.m_128405_("count", 1);
            tag.m_128405_("block", BuiltInRegistries.f_256975_.m_7447_((Object)Blocks.f_50330_));
            tag.m_128405_("entity", entity.m_19879_());
            ModMessages.sendToAllAround(new S2CParticlePacket(tag, 0.0, 0.0, 0.0), new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25.0, entity.m_9236_().m_46472_()));
        } else if (entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            if (entityRad > 600.0f) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("type", "radiation");
                tag.m_128405_("count", entityRad > 900.0f ? 4 : (entityRad > 800.0f ? 2 : 1));
                ModMessages.sendToPlayer(new S2CParticlePacket(tag, 0.0, 0.0, 0.0), player2);
            }
        }
    }

    public static void handleRadiationEffect(LivingEntity entity, IEntityAdditionalData entityData) {
        if (entityData.contains(DataEntry.RADIATION)) {
            int amplifier;
            float rad = ((Float)entityData.getData(DataEntry.RADIATION).get()).floatValue();
            int n = amplifier = entity.m_21023_((MobEffect)ModEffects.RADIATION.get()) ? entity.m_21124_((MobEffect)ModEffects.RADIATION.get()).m_19564_() : -1;
            if (rad >= 1000.0f) {
                entity.m_6074_();
            } else if (rad >= 800.0f) {
                if (amplifier < 4) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 3600, 4));
                }
            } else if (rad >= 600.0f) {
                if (amplifier < 3) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 3600, 3));
                }
            } else if (rad >= 400.0f) {
                if (amplifier < 2) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 3600, 2));
                }
            } else if (rad >= 200.0f) {
                if (amplifier < 1) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 3600, 1));
                }
            } else if (rad > 0.0f && amplifier < 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 1200, 0));
            }
        }
    }

    private static boolean canVomit(LivingEntity e) {
        return e.m_5842_() || e.m_20077_();
    }
}

