/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.addational_data.entity.living;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ContaminationEffectLists
implements INBTSerializable<CompoundTag> {
    List<ContaminationEffect> effects = new ArrayList<ContaminationEffect>();

    public List<ContaminationEffect> getEffects() {
        return this.effects;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.effects.size(); ++i) {
            this.effects.get(i).save(tag, i);
        }
        tag.m_128405_("size", this.effects.size());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            this.effects.add(ContaminationEffect.load(nbt, i));
        }
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public void serialize(ByteBuf buf) {
            buf.writeFloat(this.maxRad);
            buf.writeInt(this.maxTime);
            buf.writeInt(this.time);
            buf.writeBoolean(this.ignoreArmor);
        }

        public static ContaminationEffect deserialize(ByteBuf buf) {
            float maxRad = buf.readFloat();
            int maxTime = buf.readInt();
            int time = buf.readInt();
            boolean ignoreArmor = buf.readBoolean();
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }

        public void save(CompoundTag nbt, int index) {
            CompoundTag me = new CompoundTag();
            me.m_128350_("maxRad", this.maxRad);
            me.m_128405_("maxTime", this.maxTime);
            me.m_128405_("time", this.time);
            me.m_128379_("ignoreArmor", this.ignoreArmor);
            nbt.m_128365_("cont_" + index, (Tag)me);
        }

        public static ContaminationEffect load(CompoundTag nbt, int index) {
            CompoundTag me = (CompoundTag)nbt.m_128423_("cont_" + index);
            float maxRad = me.m_128457_("maxRad");
            int maxTime = nbt.m_128451_("maxTime");
            int time = nbt.m_128451_("time");
            boolean ignoreArmor = nbt.m_128471_("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

