/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api;

import com.hbm.api.annotations.NothingNullByDefault;
import com.hbm.api.math.MathUtils;
import com.hbm.api.text.APILang;
import com.hbm.api.text.IHasTranslationKey;
import com.hbm.api.text.ILangEntry;
import net.minecraft.core.Direction;

@NothingNullByDefault
public enum RelativeSide implements IHasTranslationKey
{
    FRONT(APILang.FRONT),
    LEFT(APILang.LEFT),
    RIGHT(APILang.RIGHT),
    BACK(APILang.BACK),
    TOP(APILang.TOP),
    BOTTOM(APILang.BOTTOM);

    public static final RelativeSide[] SIDES;
    private final ILangEntry langEntry;

    public static RelativeSide byIndex(int index) {
        return MathUtils.getByIndexMod(SIDES, index);
    }

    private RelativeSide(ILangEntry langEntry) {
        this.langEntry = langEntry;
    }

    @Override
    public String key() {
        return this.langEntry.key();
    }

    public Direction getDirection(Direction facing) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> facing;
            case BACK -> facing.m_122424_();
            case LEFT -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.EAST;
                }
                yield facing.m_122427_();
            }
            case RIGHT -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.WEST;
                }
                yield facing.m_122428_();
            }
            case TOP -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case UP: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.UP;
            }
            case BOTTOM -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.DOWN;
            }
        };
    }

    public static RelativeSide fromDirections(Direction facing, Direction side) {
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.m_122424_()) {
            return BACK;
        }
        if (facing == Direction.DOWN || facing == Direction.UP) {
            return switch (side) {
                case Direction.NORTH -> {
                    if (facing == Direction.DOWN) {
                        yield TOP;
                    }
                    yield BOTTOM;
                }
                case Direction.SOUTH -> {
                    if (facing == Direction.DOWN) {
                        yield BOTTOM;
                    }
                    yield TOP;
                }
                case Direction.WEST -> RIGHT;
                case Direction.EAST -> LEFT;
                default -> throw new IllegalStateException("Case should have been caught earlier.");
            };
        }
        if (side == Direction.DOWN) {
            return BOTTOM;
        }
        if (side == Direction.UP) {
            return TOP;
        }
        if (side == facing.m_122428_()) {
            return RIGHT;
        }
        if (side == facing.m_122427_()) {
            return LEFT;
        }
        return FRONT;
    }

    static {
        SIDES = RelativeSide.values();
    }
}

