/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.badthing;

import com.hbm.api.badthing.HazmatRegistry;
import com.hbm.api.badthing.HbmLivingProps;
import com.hbm.handler.radiation.ChunkRadiationManager;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;

public class ContaminationUtil {
    public static HashSet<Class> immuneEntities = new HashSet();

    public static float calculateRadiationMod(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float koeff = 10.0f;
            return (float)Math.pow(koeff, -HazmatRegistry.getResistance(player));
        }
        return 1.0f;
    }

    public static float getRads(Entity e) {
        if (!(e instanceof LivingEntity)) {
            return 0.0f;
        }
        if (ContaminationUtil.isRadImmune(e)) {
            return 0.0f;
        }
        LivingEntity entity = (LivingEntity)e;
        return HbmLivingProps.getRadiation(entity);
    }

    public static boolean isRadImmune(Entity e) {
        if (immuneEntities.isEmpty()) {
            // empty if block
        }
        Class<?> entityClass = e.getClass();
        for (Class clazz : immuneEntities) {
            if (!clazz.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return "cyano.lootable.entities.EntityLootableBody".equals(entityClass.getName());
    }

    public static void applyAsbestos(Entity e, int i) {
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)e;
        if (e instanceof Player && ((Player)e).m_7500_()) {
            return;
        }
        if (e instanceof Player && e.f_19797_ < 200) {
            return;
        }
        HbmLivingProps.incrementAsbestos(entity, i);
    }

    public static void applyDigammaData(Entity e, float f) {
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)e;
        if (e instanceof Player && ((Player)e).m_7500_()) {
            return;
        }
        if (e instanceof Player && e.f_19797_ < 200) {
            return;
        }
    }

    public static void applyDigammaDirect(Entity e, float f) {
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)e;
        if (e instanceof Player && ((Player)e).m_7500_()) {
            return;
        }
        HbmLivingProps.incrementDigamma(entity, f);
    }

    public static float getDigamma(Entity e) {
        if (!(e instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity entity = (LivingEntity)e;
        return HbmLivingProps.getDigamma(entity);
    }

    public static void printGeigerData(Player player) {
        Level world = player.m_9236_();
        double eRad = (double)((int)(HbmLivingProps.getRadiation((LivingEntity)player) * 10.0f)) / 10.0;
        double rads = (double)((int)ChunkRadiationManager.proxy.getRadiation(world, player.m_20097_()) * 10) / 10.0;
        double env = (double)((int)((double)HbmLivingProps.getRadBuf((LivingEntity)player) * 10.0)) / 10.0;
        double res = (double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0;
        double resKoeff = (double)((int)((double)HazmatRegistry.getResistance(player) * 100.0)) / 100.0;
        String chunkPrefix = ContaminationUtil.getPreffixFromRad(rads);
        String envPrefix = ContaminationUtil.getPreffixFromRad(env);
        Object radPrefix = "";
        String resPrefix = String.valueOf(ChatFormatting.WHITE);
        radPrefix = eRad < 200.0 ? (String)radPrefix + String.valueOf(ChatFormatting.GREEN) : (eRad < 400.0 ? (String)radPrefix + String.valueOf(ChatFormatting.YELLOW) : (eRad < 600.0 ? (String)radPrefix + String.valueOf(ChatFormatting.GOLD) : (eRad < 800.0 ? (String)radPrefix + String.valueOf(ChatFormatting.RED) : (eRad < 1000.0 ? (String)radPrefix + String.valueOf(ChatFormatting.DARK_RED) : (String)radPrefix + String.valueOf(ChatFormatting.DARK_GRAY)))));
        if (resKoeff > 0.0) {
            resPrefix = resPrefix + String.valueOf(ChatFormatting.GREEN);
        }
        player.m_5661_((Component)Component.m_237113_((String)"===== \u2622 ").m_7220_((Component)Component.m_237115_((String)"geiger.title")).m_7220_((Component)Component.m_237113_((String)" \u2622 =====")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        player.m_5661_((Component)Component.m_237115_((String)"geiger.chunkRad").m_7220_((Component)Component.m_237113_((String)(" " + chunkPrefix + rads + " RAD/s"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
        player.m_5661_((Component)Component.m_237115_((String)"geiger.envRad").m_7220_((Component)Component.m_237113_((String)(" " + envPrefix + env + " RAD/s"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
        player.m_5661_((Component)Component.m_237115_((String)"geiger.playerRad").m_7220_((Component)Component.m_237113_((String)(" " + (String)radPrefix + eRad + " RAD"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
        player.m_5661_((Component)Component.m_237115_((String)"geiger.playerRes").m_7220_((Component)Component.m_237113_((String)(" " + resPrefix + res + "% (" + resKoeff + ")"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
    }

    public static void printDosimeterData(Player player) {
        double env = (double)((int)((double)HbmLivingProps.getRadBuf((LivingEntity)player) * 10.0)) / 10.0;
        boolean limit = false;
        if (env > 3.6) {
            env = 3.6;
            limit = true;
        }
        String envPrefix = ContaminationUtil.getPreffixFromRad(env);
        player.m_5661_((Component)Component.m_237113_((String)"===== \u2622 ").m_7220_((Component)Component.m_237115_((String)"geiger.title.dosimeter")).m_7220_((Component)Component.m_237113_((String)" \u2622 =====")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        player.m_5661_((Component)Component.m_237115_((String)"geiger.envRad").m_7220_((Component)Component.m_237113_((String)(" " + envPrefix + (limit ? ">" : "") + env + " RAD/s"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
    }

    public static String getPreffixFromRad(double rads) {
        Object chunkPrefix = "";
        chunkPrefix = rads == 0.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.GREEN) : (rads < 1.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.YELLOW) : (rads < 10.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.GOLD) : (rads < 100.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.RED) : (rads < 1000.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.DARK_RED) : (String)chunkPrefix + String.valueOf(ChatFormatting.DARK_GRAY)))));
        return chunkPrefix;
    }

    public static void printDiagnosticData(Player player) {
        double digamma = (double)((int)(HbmLivingProps.getDigamma((LivingEntity)player) * 100.0f)) / 100.0;
        double halflife = (double)((int)((1.0 - Math.pow(0.5, digamma)) * 10000.0)) / 100.0;
        player.m_5661_((Component)Component.m_237113_((String)"===== \u03dc ").m_7220_((Component)Component.m_237115_((String)"digamma.title")).m_7220_((Component)Component.m_237113_((String)" \u03dc =====")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), true);
        player.m_5661_((Component)Component.m_237115_((String)"digamma.playerDigamma").m_7220_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.RED) + " " + digamma + " DRX"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), true);
        player.m_5661_((Component)Component.m_237115_((String)"digamma.playerHealth").m_7220_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.RED) + " " + halflife + "%"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), true);
        player.m_5661_((Component)Component.m_237115_((String)"digamma.playerRes").m_7220_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.BLUE) + " N/A"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), true);
    }

    public static boolean isPotionUseful(LivingEntity entity, Potion potion) {
        for (MobEffectInstance effect : potion.m_43488_()) {
            if (!entity.m_7301_(effect)) continue;
            return true;
        }
        return false;
    }

    public static boolean contaminate(LivingEntity entity, HazardType hazard, ContaminationType cont, float amount) {
        if (hazard == HazardType.RADIATION) {
            float radEnv = HbmLivingProps.getRadEnv(entity);
            HbmLivingProps.setRadEnv(entity, radEnv + amount);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_() && cont != ContaminationType.NONE && cont != ContaminationType.DIGAMMA2) {
                return false;
            }
            if (player.f_19797_ < 200) {
                return false;
            }
        }
        if (hazard == HazardType.RADIATION && ContaminationUtil.isRadImmune((Entity)entity)) {
            return false;
        }
        switch (hazard) {
            case RADIATION: {
                HbmLivingProps.incrementRadiation(entity, amount * (cont == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case DIGAMMA: {
                HbmLivingProps.incrementDigamma(entity, amount);
            }
        }
        return true;
    }

    public static enum HazardType {
        RADIATION,
        DIGAMMA;

    }

    public static enum ContaminationType {
        FARADAY,
        HAZMAT,
        HAZMAT2,
        DIGAMMA,
        DIGAMMA2,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }
}

