/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.badthing;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBM;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HazmatRegistry {
    private static HashMap<Item, Double> entries = new HashMap();
    public static final Gson gson = new Gson();

    public static void initDefault() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double iron = 0.0225;
        double gold = 0.0225;
        double steel = 0.045;
        double titanium = 0.045;
        double alloy = 0.07;
        double cobalt = 0.125;
        double hazYellow = 0.6;
        double hazRed = 1.0;
        double hazGray = 2.0;
        double paa = 1.7;
        double liquidator = 2.4;
        double t45 = 1.0;
        double ajr = 1.3;
        double bj = 1.0;
        double env = 1.0;
        double hev = 2.3;
        double rpa = 2.0;
        double trench = 1.0;
        double fau = 4.0;
        double dns = 5.0;
        double security = 0.825;
        double star = 1.0;
        double cmb = 1.3;
        double schrab = 3.0;
        double euph = 10.0;
        HazmatRegistry.registerHazmat(Items.f_42468_, iron * helmet);
        HazmatRegistry.registerHazmat(Items.f_42469_, iron * chest);
        HazmatRegistry.registerHazmat(Items.f_42470_, iron * legs);
        HazmatRegistry.registerHazmat(Items.f_42471_, iron * boots);
        HazmatRegistry.registerHazmat(Items.f_42476_, gold * helmet);
        HazmatRegistry.registerHazmat(Items.f_42477_, gold * chest);
        HazmatRegistry.registerHazmat(Items.f_42478_, gold * legs);
        HazmatRegistry.registerHazmat(Items.f_42479_, gold * boots);
    }

    public static void registerHazmat(Item item, double resistance) {
        entries.put(item, resistance);
    }

    public static double getResistance(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        double cladding = HazmatRegistry.getCladding(stack);
        Double f = entries.get(stack.m_41720_());
        if (f != null) {
            return f + cladding;
        }
        return cladding;
    }

    public static double getCladding(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128457_("hfr_cladding") > 0.0f) {
            return stack.m_41783_().m_128457_("hfr_cladding");
        }
        return 0.0;
    }

    public static float getResistance(Player player) {
        float res = 0.0f;
        for (int i = 0; i < 4; ++i) {
            res += (float)HazmatRegistry.getResistance(player.m_150109_().m_36052_(i));
        }
        return res;
    }

    public static void registerHazmats() {
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            writer.name("entries").beginArray();
            for (Map.Entry<Item, Double> entry : entries.entrySet()) {
                writer.beginObject();
                writer.name("resistance").value((Number)entry.getValue());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HashMap<Item, Double> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray array = json.get("entries").getAsJsonArray();
            HashMap<Item, Double> conf = new HashMap<Item, Double>();
            for (JsonElement element : array) {
                JsonObject object = (JsonObject)element;
                try {
                    String string = object.get("item").getAsString();
                }
                catch (Exception ex) {
                    HBM.LOGGER.error("Encountered " + String.valueOf(ex) + " trying to read hazmat entry " + element.toString());
                }
            }
            return conf;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

