/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.badthing;

import com.hbm.config.RadiationConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;

public class HbmLivingProps {
    public static final String key = "NTM_EXT_LIVING";
    public static final UUID digamma_UUID = UUID.fromString("2a3d8aec-5ab9-4218-9b8b-ca812bdf378b");
    public LivingEntity entity;
    private float radiation;
    private float digamma;
    private int asbestos;
    public static final int maxAsbestos = 72000;
    private int blacklung;
    public static final int maxBlacklung = 144000;
    private float radEnv;
    private float radBuf;
    private int bombTimer;
    private int contagion;
    private int oil;
    public int fire;
    public int balefire;
    private List<ContaminationEffect> contamination = new ArrayList<ContaminationEffect>();

    public HbmLivingProps(LivingEntity entity) {
        this.entity = entity;
    }

    public static HbmLivingProps registerData(LivingEntity entity) {
        return null;
    }

    public static HbmLivingProps getData(LivingEntity entity) {
        return HbmLivingProps.loadNBTData(entity);
    }

    public static CompoundTag toNBTData(HbmLivingProps hbmLivingProps) {
        CompoundTag props = new CompoundTag();
        props.m_128350_("hfr_radiation", hbmLivingProps.radiation);
        props.m_128350_("hfr_digamma", hbmLivingProps.digamma);
        props.m_128405_("hfr_asbestos", hbmLivingProps.asbestos);
        props.m_128405_("hfr_bomb", hbmLivingProps.bombTimer);
        props.m_128405_("hfr_contagion", hbmLivingProps.contagion);
        props.m_128405_("hfr_blacklung", hbmLivingProps.blacklung);
        props.m_128405_("hfr_oil", hbmLivingProps.oil);
        props.m_128405_("hfr_fire", hbmLivingProps.fire);
        props.m_128405_("hfr_balefire", hbmLivingProps.balefire);
        props.m_128405_("hfr_cont_count", hbmLivingProps.contamination.size());
        for (int i = 0; i < hbmLivingProps.contamination.size(); ++i) {
            hbmLivingProps.contamination.get(i).save(props, i);
        }
        return props;
    }

    public static HbmLivingProps loadNBTData(LivingEntity entity) {
        CompoundTag props = (CompoundTag)entity.getPersistentData().m_128423_(key);
        HbmLivingProps hbmLivingProps = new HbmLivingProps(entity);
        if (props == null) {
            entity.getPersistentData().m_128365_(key, (Tag)HbmLivingProps.toNBTData(hbmLivingProps));
            return hbmLivingProps;
        }
        if (props != null) {
            hbmLivingProps.radiation = props.m_128457_("hfr_radiation");
            hbmLivingProps.digamma = props.m_128457_("hfr_digamma");
            hbmLivingProps.asbestos = props.m_128451_("hfr_asbestos");
            hbmLivingProps.bombTimer = props.m_128451_("hfr_bomb");
            hbmLivingProps.contagion = props.m_128451_("hfr_contagion");
            hbmLivingProps.blacklung = props.m_128451_("hfr_blacklung");
            hbmLivingProps.oil = props.m_128451_("hfr_oil");
            hbmLivingProps.fire = props.m_128451_("hfr_fire");
            hbmLivingProps.balefire = props.m_128451_("hfr_balefire");
            int cont = props.m_128451_("hfr_cont_count");
            for (int i = 0; i < cont; ++i) {
                hbmLivingProps.contamination.add(ContaminationEffect.load(props, i));
            }
        }
        return hbmLivingProps;
    }

    public static float getRadiation(LivingEntity entity) {
        if (!RadiationConfig.enableContamination) {
            return 0.0f;
        }
        return HbmLivingProps.getData((LivingEntity)entity).radiation;
    }

    public static void setRadiation(LivingEntity entity, float rad) {
        if (RadiationConfig.enableContamination) {
            HbmLivingProps.getData((LivingEntity)entity).radiation = rad;
        }
    }

    public static void incrementRadiation(LivingEntity entity, float rad) {
        if (!RadiationConfig.enableContamination) {
            return;
        }
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float radiation = HbmLivingProps.getData((LivingEntity)entity).radiation + rad;
        if (radiation > 2500.0f) {
            radiation = 2500.0f;
        }
        if (radiation < 0.0f) {
            radiation = 0.0f;
        }
        HbmLivingProps.setRadiation(entity, radiation);
    }

    public static float getRadEnv(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).radEnv;
    }

    public static void setRadEnv(LivingEntity entity, float rad) {
        HbmLivingProps.getData((LivingEntity)entity).radEnv = rad;
    }

    public static float getRadBuf(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).radBuf;
    }

    public static void setRadBuf(LivingEntity entity, float rad) {
        HbmLivingProps.getData((LivingEntity)entity).radBuf = rad;
    }

    public static List<ContaminationEffect> getCont(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).contamination;
    }

    public static void addCont(LivingEntity entity, ContaminationEffect cont) {
        HbmLivingProps.getData((LivingEntity)entity).contamination.add(cont);
    }

    public static float getDigamma(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).digamma;
    }

    public static void setDigamma(LivingEntity entity, float digamma) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        HbmLivingProps.getData((LivingEntity)entity).digamma = digamma;
        float healthMod = (float)Math.pow(0.5, digamma) - 1.0f;
        if (entity.m_21223_() > entity.m_21233_() && entity.m_21233_() > 0.0f) {
            entity.m_21153_(entity.m_21233_());
        }
    }

    public static void incrementDigamma(LivingEntity entity, float digamma) {
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float dRad = HbmLivingProps.getDigamma(entity) + digamma;
        if (dRad > 10.0f) {
            dRad = 10.0f;
        }
        if (dRad < 0.0f) {
            dRad = 0.0f;
        }
        HbmLivingProps.setDigamma(entity, dRad);
    }

    public static int getAsbestos(LivingEntity entity) {
        if (RadiationConfig.disableAsbestos) {
            return 0;
        }
        return HbmLivingProps.getData((LivingEntity)entity).asbestos;
    }

    public static void setAsbestos(LivingEntity entity, int asbestos) {
        if (RadiationConfig.disableAsbestos) {
            return;
        }
        HbmLivingProps.getData((LivingEntity)entity).asbestos = asbestos;
        if (asbestos >= 72000) {
            HbmLivingProps.getData((LivingEntity)entity).asbestos = 0;
        }
    }

    public static void incrementAsbestos(LivingEntity entity, int asbestos) {
        if (RadiationConfig.disableAsbestos) {
            return;
        }
        HbmLivingProps.setAsbestos(entity, HbmLivingProps.getAsbestos(entity) + asbestos);
    }

    public static int getBlackLung(LivingEntity entity) {
        if (RadiationConfig.disableCoal) {
            return 0;
        }
        return HbmLivingProps.getData((LivingEntity)entity).blacklung;
    }

    public static void setBlackLung(LivingEntity entity, int blacklung) {
        if (RadiationConfig.disableCoal) {
            return;
        }
        HbmLivingProps.getData((LivingEntity)entity).blacklung = blacklung;
        if (blacklung >= 144000) {
            HbmLivingProps.getData((LivingEntity)entity).blacklung = 0;
        }
    }

    public static void incrementBlackLung(LivingEntity entity, int blacklung) {
        if (RadiationConfig.disableCoal) {
            return;
        }
        HbmLivingProps.setBlackLung(entity, HbmLivingProps.getBlackLung(entity) + blacklung);
    }

    public static int getTimer(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).bombTimer;
    }

    public static void setTimer(LivingEntity entity, int bombTimer) {
        HbmLivingProps.getData((LivingEntity)entity).bombTimer = bombTimer;
    }

    public static int getContagion(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).contagion;
    }

    public static void setContagion(LivingEntity entity, int contageon) {
        HbmLivingProps.getData((LivingEntity)entity).contagion = contageon;
    }

    public static int getOil(LivingEntity entity) {
        return HbmLivingProps.getData((LivingEntity)entity).oil;
    }

    public static void setOil(LivingEntity entity, int oil) {
        HbmLivingProps.getData((LivingEntity)entity).oil = oil;
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public void save(CompoundTag nbt, int index) {
            CompoundTag me = new CompoundTag();
            me.m_128350_("maxRad", this.maxRad);
            me.m_128405_("maxTime", this.maxTime);
            me.m_128405_("time", this.time);
            me.m_128379_("ignoreArmor", this.ignoreArmor);
            nbt.m_128365_("cont_" + index, (Tag)me);
        }

        public static ContaminationEffect load(CompoundTag nbt, int index) {
            CompoundTag me = (CompoundTag)nbt.m_128423_("cont_" + index);
            assert (me != null);
            float maxRad = me.m_128457_("maxRad");
            int maxTime = nbt.m_128451_("maxTime");
            int time = nbt.m_128451_("time");
            boolean ignoreArmor = nbt.m_128471_("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

