/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.badthing.hazard;

import com.hbm.Untested;
import com.hbm.api.badthing.hazard.ComparableStack;
import com.hbm.api.badthing.hazard.HazardData;
import com.hbm.api.badthing.hazard.HazardEntry;
import com.hbm.api.badthing.hazard.modifier.HazardModifier;
import com.hbm.api.badthing.hazard.transformers.HazardTransformerBase;
import com.hbm.api.badthing.hazard.type.HazardTypeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Untested
public class HazardSystem {
    public static final HashMap<String, HazardData> oreMap = new HashMap();
    public static final HashMap<Item, HazardData> itemMap = new HashMap();
    public static final HashMap<ComparableStack, HazardData> stackMap = new HashMap();
    public static final HashSet<ComparableStack> stackBlacklist = new HashSet();
    public static final HashSet<String> dictBlacklist = new HashSet();
    public static final List<HazardTransformerBase> trafos = new ArrayList<HazardTransformerBase>();

    public static void register(Object o, HazardData data) {
        if (o instanceof String) {
            oreMap.put((String)o, data);
        }
        if (o instanceof Item) {
            itemMap.put((Item)o, data);
        }
        if (o instanceof Block) {
            itemMap.put(((Block)o).m_5456_(), data);
        }
        if (o instanceof ItemStack) {
            stackMap.put(new ComparableStack((ItemStack)o), data);
        }
        if (o instanceof ComparableStack) {
            stackMap.put((ComparableStack)o, data);
        }
    }

    public static void blacklist(Object o) {
        if (o instanceof ItemStack) {
            stackBlacklist.add(new ComparableStack((ItemStack)o).makeSingular());
        } else if (o instanceof String) {
            dictBlacklist.add((String)o);
        }
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        return stackBlacklist.contains(new ComparableStack(stack).makeSingular());
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        ComparableStack comp;
        if (HazardSystem.isItemBlacklisted(stack)) {
            return new ArrayList<HazardEntry>();
        }
        ArrayList<HazardData> chronological = new ArrayList<HazardData>();
        if (itemMap.containsKey(stack.m_41720_())) {
            chronological.add(itemMap.get(stack.m_41720_()));
        }
        if (stackMap.containsKey(comp = new ComparableStack(stack).makeSingular())) {
            chronological.add(stackMap.get(comp));
        }
        ArrayList<HazardEntry> entries = new ArrayList<HazardEntry>();
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPre(stack, entries);
        }
        int mutex = 0;
        for (HazardData data : chronological) {
            if (data.doesOverride) {
                entries.clear();
            }
            if ((data.getMutex() & mutex) != 0) continue;
            entries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPost(stack, entries);
        }
        return entries;
    }

    public static float getHazardLevelFromStack(ItemStack stack, HazardTypeBase hazard) {
        List<HazardEntry> entries = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : entries) {
            if (entry.type != hazard) continue;
            return HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods);
        }
        return 0.0f;
    }

    public static void applyHazards(ItemStack stack, LivingEntity entity) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.applyHazard(stack, entity);
        }
    }

    public static void updatePlayerInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
            if (!stack.m_41619_()) continue;
            player.m_150109_().m_36057_(stack);
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
        }
    }

    public static void updateLivingInventory(LivingEntity entity) {
        for (ItemStack stack : entity.m_20158_()) {
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, entity);
        }
    }

    public static void updateDroppedItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        if (!entity.m_6084_() || stack.m_41619_()) {
            return;
        }
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : hazards) {
            entry.type.updateEntity(entity, HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addFullTooltip(ItemStack stack, Player player, List list) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.type.addHazardInformation(player, list, hazard.baseLevel, stack, hazard.mods);
        }
    }
}

