/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy;

import com.hbm.api.IContentsListener;
import com.hbm.api.energy.IEnergyContainer;

public class BasicEnergyContainer
implements IEnergyContainer {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    IContentsListener listener;

    public BasicEnergyContainer(long capacity) {
        this(capacity, capacity, capacity, 0L);
    }

    public BasicEnergyContainer(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0L);
    }

    public BasicEnergyContainer(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, 0L);
    }

    public BasicEnergyContainer(long capacity, long maxReceive, long maxExtract, long energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, energy));
    }

    public void setListener(IContentsListener listener) {
        this.listener = listener;
    }

    @Override
    public long getEnergy() {
        return this.energy;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        if (energy >= 0L && energy <= this.capacity) {
            this.energy = energy;
        }
    }

    @Override
    public void setCapacity(long capacity) {
        if (capacity >= 0L) {
            this.capacity = capacity;
        }
    }

    @Override
    public long getInputLimit() {
        return this.maxReceive;
    }

    @Override
    public long getOutputLimit() {
        return this.maxExtract;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }
}

