/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy;

import com.hbm.api.energy.IEnergyContainer;
import net.minecraftforge.energy.IEnergyStorage;

public final class HybridEnergyStorage
implements IEnergyStorage {
    private final IEnergyContainer delegate;
    private final int ratio;

    public HybridEnergyStorage(IEnergyContainer delegate) {
        this(delegate, 4);
    }

    public HybridEnergyStorage(IEnergyContainer delegate, int ratio) {
        this.delegate = delegate;
        this.ratio = Math.max(1, ratio);
    }

    private long toLong(int fe) {
        return (long)fe * (long)this.ratio;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive() || maxReceive <= 0) {
            return 0;
        }
        long accepted = this.delegate.receive(this.toLong(maxReceive), simulate);
        return (int)Math.min(Integer.MAX_VALUE, accepted / (long)this.ratio);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract() || maxExtract <= 0) {
            return 0;
        }
        long extracted = this.delegate.extract(this.toLong(maxExtract), simulate);
        return (int)Math.min(Integer.MAX_VALUE, extracted / (long)this.ratio);
    }

    public int getEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.delegate.getEnergy() / (long)this.ratio);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.delegate.getCapacity() / (long)this.ratio);
    }

    public boolean canExtract() {
        return this.delegate.canExtract();
    }

    public boolean canReceive() {
        return this.delegate.canReceive();
    }
}

