/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy;

import com.hbm.api.IContentsListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public interface IEnergyContainer
extends IContentsListener,
INBTSerializable<CompoundTag> {
    public long getEnergy();

    public long getCapacity();

    public void setEnergy(long var1);

    public void setCapacity(long var1);

    default public long getInputLimit() {
        return Long.MAX_VALUE;
    }

    default public long getOutputLimit() {
        return Long.MAX_VALUE;
    }

    default public boolean canReceive() {
        return this.getInputLimit() > 0L;
    }

    default public boolean canExtract() {
        return this.getOutputLimit() > 0L;
    }

    default public long receive(long maxReceive, boolean simulate) {
        if (maxReceive <= 0L || !this.canReceive()) {
            return 0L;
        }
        long amount = Math.min(maxReceive, Math.min(this.getInputLimit(), this.getNeeded()));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + amount);
            this.onContentsChanged();
        }
        return amount;
    }

    default public long extract(long maxExtract, boolean simulate) {
        if (maxExtract <= 0L || !this.canExtract()) {
            return 0L;
        }
        long amount = Math.min(maxExtract, Math.min(this.getOutputLimit(), this.getEnergy()));
        if (!simulate) {
            this.setEnergy(this.getEnergy() - amount);
            this.onContentsChanged();
        }
        return amount;
    }

    default public long getNeeded() {
        return this.getCapacity() - this.getEnergy();
    }

    default public double getPercent() {
        return (double)this.getEnergy() / (double)this.getCapacity();
    }

    default public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("stored", (Tag)LongTag.m_128882_((long)this.getEnergy()));
        return nbt;
    }

    default public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        this.setEnergy(nbt.m_128454_("stored"));
    }
}

