/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy;

import com.hbm.api.IContentsListener;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.capabilities.HBMCaps;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.capabilities.resolver.BasicCapabilityResolver;
import com.hbm.capabilities.resolver.ICapabilityResolver;
import com.hbm.utils.ItemDataUtils;
import java.util.function.Consumer;

public class ItemStackEnergyHandler
extends ItemCapabilityWrapper.ItemCapability
implements IContentsListener {
    protected BasicEnergyContainer energyStorage = null;

    public ItemStackEnergyHandler(long capacity, long inout, boolean isEmpty) {
        this(new BasicEnergyContainer(capacity, inout));
        if (!isEmpty) {
            this.energyStorage.setEnergy(capacity);
        }
    }

    public ItemStackEnergyHandler(BasicEnergyContainer energyStorage) {
        this.energyStorage = energyStorage;
        this.energyStorage.setListener(this);
    }

    public ItemStackEnergyHandler(long capacity, long input, long output, boolean isEmpty) {
        this(new BasicEnergyContainer(capacity, input, output));
        if (!isEmpty) {
            this.energyStorage.setEnergy(capacity);
        }
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(new BasicCapabilityResolver(() -> new ProxyEnergyHandler(this.energyStorage), HBMCaps.LONG_ENERGY));
    }

    @Override
    protected void load() {
        super.load();
        ItemDataUtils.readContainers(this.getStack(), "energy", this.energyStorage);
        this.saveDamageValue();
    }

    @Override
    public void onContentsChanged() {
        ItemDataUtils.writeContainers(this.getStack(), "energy", this.energyStorage);
        this.saveDamageValue();
    }

    private void saveDamageValue() {
        if (this.getStack().m_41763_()) {
            this.getStack().m_41721_((int)((1.0 - this.energyStorage.getPercent()) * (double)this.getStack().m_41776_()));
        }
    }
}

