/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy;

import com.hbm.api.energy.FEAdapter;
import com.hbm.api.energy.IEnergyHandler;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.capabilities.HBMCaps;
import com.hbm.item.HBMItems;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class TransmitUtils {
    public static IEnergyHandler getEnergyCapability(BlockEntity pBlockEntity, Direction pSide) {
        IEnergyHandler energyHandler = null;
        if (pBlockEntity.getCapability(HBMCaps.LONG_ENERGY, pSide).isPresent()) {
            energyHandler = (IEnergyHandler)pBlockEntity.getCapability(HBMCaps.LONG_ENERGY, pSide).orElse(null);
        } else if (pBlockEntity.getCapability(ForgeCapabilities.ENERGY, pSide).isPresent()) {
            IEnergyStorage iEnergyStorage = (IEnergyStorage)pBlockEntity.getCapability(ForgeCapabilities.ENERGY, pSide).orElse(null);
            energyHandler = new ProxyEnergyHandler(new FEAdapter(iEnergyStorage));
        }
        return energyHandler;
    }

    public static void dischargeItem(BlockEntity pBlockEntity, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        IEnergyHandler energyHandler = (IEnergyHandler)pBlockEntity.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (energyHandler == null) {
            return;
        }
        IEnergyHandler itemEnergy = (IEnergyHandler)itemStack.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (itemEnergy == null && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            IEnergyStorage FEStorage = (IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
            itemEnergy = new ProxyEnergyHandler(new FEAdapter(FEStorage));
        }
        long needed = energyHandler.getEnergyContainer().getNeeded();
        if (itemStack.m_150930_((Item)HBMItems.BATTERY_CREATIVE.get())) {
            energyHandler.setEnergy(energyHandler.getCapacity());
            return;
        }
        if (itemEnergy == null) {
            return;
        }
        energyHandler.receive(itemEnergy.extract(needed, false), false);
    }

    public static void chargeItem(BlockEntity pBlockEntity, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        IEnergyHandler energyHandler = (IEnergyHandler)pBlockEntity.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (energyHandler == null) {
            return;
        }
        IEnergyHandler itemEnergy = (IEnergyHandler)itemStack.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (itemEnergy == null && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            IEnergyStorage FEStorage = (IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
            itemEnergy = new ProxyEnergyHandler(new FEAdapter(FEStorage));
        }
        if (itemEnergy == null) {
            return;
        }
        if (itemStack.m_150930_((Item)HBMItems.BATTERY_CREATIVE.get())) {
            return;
        }
        energyHandler.extract(itemEnergy.receive(energyHandler.getStored(), false), false);
    }

    public static void outputOnly(BlockEntity pBlockEntity) {
        IEnergyHandler energyHandler = TransmitUtils.getEnergyCapability(pBlockEntity, null);
        if (energyHandler == null || pBlockEntity.m_58904_() == null) {
            return;
        }
        IEnergyHandler neighborHandler = null;
        for (Direction direction : Direction.values()) {
            BlockEntity neighborEntity = pBlockEntity.m_58904_().m_7702_(pBlockEntity.m_58899_().m_121945_(direction));
            if (neighborEntity == null) continue;
            energyHandler = TransmitUtils.getEnergyCapability(pBlockEntity, direction);
            neighborHandler = TransmitUtils.getEnergyCapability(neighborEntity, direction.m_122424_());
            if (energyHandler == null || neighborHandler == null || !energyHandler.canExtract() || !neighborHandler.canReceive()) continue;
            energyHandler.extract(neighborHandler.receive(energyHandler.getStored(), false), false);
        }
    }

    public static void dischargeOnly(ICapabilityProvider provider, long amount) {
        provider.getCapability(HBMCaps.LONG_ENERGY).ifPresent(iEnergyHandler -> iEnergyHandler.extract(amount, false));
    }
}

