/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.api.energy.fe;

import com.hbm.api.IContentsListener;
import com.hbm.api.energy.fe.IHBMEnergyStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class HBMEnergyStorage
implements IHBMEnergyStorage,
INBTSerializable<CompoundTag> {
    long longEnergy;
    long longCapacity;
    long output;
    long input;
    static long BASIC_INOUT = 10000L;
    IContentsListener listener;

    public HBMEnergyStorage(long capacity) {
        this(capacity, BASIC_INOUT);
    }

    public HBMEnergyStorage(long capacity, long inout) {
        this(0L, capacity, inout, inout);
    }

    public HBMEnergyStorage(long capacity, long output, long input) {
        this(0L, capacity, output, input);
    }

    public HBMEnergyStorage(long energy, long capacity, long output, long input) {
        this.longEnergy = energy;
        this.longCapacity = capacity;
        this.output = output;
        this.input = input;
    }

    public static HBMEnergyStorage input(long capacity) {
        return new HBMEnergyStorage(0L, capacity, 0L, BASIC_INOUT);
    }

    public static HBMEnergyStorage output(long capacity) {
        return new HBMEnergyStorage(0L, capacity, BASIC_INOUT, 0L);
    }

    @Override
    public void setListener(IContentsListener listener) {
        this.listener = listener;
    }

    @Override
    public void setEnergy(long energy) {
        this.longEnergy = energy;
        this.onContentsChanged();
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        if (this.isCreative()) {
            return 0L;
        }
        long energyReceived = Math.min(this.longCapacity - this.longEnergy, Math.min(this.input, maxReceive));
        if (!simulate) {
            this.longEnergy += energyReceived;
            this.onContentsChanged();
        }
        return energyReceived;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.receiveEnergy((long)maxReceive, simulate);
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        if (this.isCreative()) {
            return maxExtract;
        }
        long energyExtracted = Math.min(this.longEnergy, Math.min(this.output, maxExtract));
        if (!simulate) {
            this.longEnergy -= energyExtracted;
            this.onContentsChanged();
        }
        return energyExtracted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.extractEnergy((long)maxExtract, simulate);
    }

    public long recipeExtract(long maxExtract, boolean simulate) {
        long temp = this.output;
        this.output = this.input;
        long result = this.extractEnergy(maxExtract, simulate);
        this.output = temp;
        return result;
    }

    @Override
    public long getLongStore() {
        return this.longEnergy;
    }

    public int getEnergyStored() {
        return HBMEnergyStorage.long2int(this.longEnergy);
    }

    @Override
    public long getLongCapacity() {
        return this.longCapacity;
    }

    @Override
    public long getMaxInput() {
        return Math.min(this.input, this.getNeeded());
    }

    @Override
    public long getMaxOutput() {
        return Math.min(this.output, this.getLongStore());
    }

    public int getMaxEnergyStored() {
        return HBMEnergyStorage.long2int(this.longCapacity);
    }

    public boolean canExtract() {
        return this.output > 0L;
    }

    public boolean canReceive() {
        return this.input > 0L;
    }

    static int long2int(long num) {
        return Math.min((int)num, Integer.MAX_VALUE);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("stored", (Tag)LongTag.m_128882_((long)this.longEnergy));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        this.longEnergy = nbt.m_128454_("stored");
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    public double getPercent() {
        return (double)this.longEnergy / (double)this.longCapacity;
    }

    public boolean isCreative() {
        return this.longCapacity < 0L;
    }
}

